/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidFileSystem
implements ConfigDef.Validator {
    private static final Logger log = LoggerFactory.getLogger(ValidFileSystem.class);
    public final boolean ensureWritable;

    protected ValidFileSystem(boolean ensureWritable) {
        this.ensureWritable = ensureWritable;
    }

    protected abstract void ensureValid(String var1, Object var2, File var3);

    public void ensureValid(String setting, Object input) {
        log.trace("ensureValid('{}', '{}')", (Object)setting, input);
        Preconditions.checkState((boolean)(input instanceof String), (String)"'%s' must be a string", (Object[])new Object[]{setting});
        String value = input.toString();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"'%s' cannot be null or empty.", (Object[])new Object[]{setting});
        File file = new File(value);
        Preconditions.checkState((boolean)file.isAbsolute(), (String)"'%s'(%s) is not an absolute path.", (Object[])new Object[]{setting, file});
        this.ensureValid(setting, input, file);
        if (this.ensureWritable) {
            Preconditions.checkState((boolean)file.canWrite(), (String)"'%s'(%s) should be writable.", (Object[])new Object[]{setting, file});
        }
        Preconditions.checkState((boolean)file.canRead(), (String)"'%s'(%s) should be readable.", (Object[])new Object[]{setting, file});
    }
}

