/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitionCounter {
    private final Map<TopicPartition, Long> data = new ConcurrentHashMap<TopicPartition, Long>(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(TopicPartition topicPartition, long offset) {
        Preconditions.checkNotNull((Object)topicPartition, (Object)"topicPartition cannot be null.");
        Preconditions.checkState((offset > 0L ? 1 : 0) != 0, (Object)"offset must be greater than 0.");
        Map<TopicPartition, Long> map = this.data;
        synchronized (map) {
            long current = this.data.getOrDefault(topicPartition, Long.MIN_VALUE);
            if (offset > current) {
                this.data.put(topicPartition, offset);
            }
        }
    }

    public void increment(String topic, int partition, long offset) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)topic) ? 1 : 0) != 0, (Object)"topic cannot be null or empty.");
        this.increment(new TopicPartition(topic, partition), offset);
    }

    public Map<TopicPartition, Long> data() {
        return ImmutableMap.copyOf(this.data);
    }
}

