/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jcustenborder.kafka.connect.utils.data.ParserKey;
import com.github.jcustenborder.kafka.connect.utils.data.type.BooleanParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.DateTypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.DecimalTypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Float32TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Float64TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Int16TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Int32TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Int64TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.Int8TypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.StringTypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.TimeTypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.TimestampTypeParser;
import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import com.github.jcustenborder.repackaged.com.google.common.base.Joiner;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import com.github.jcustenborder.repackaged.com.google.common.collect.ImmutableList;
import com.github.jcustenborder.repackaged.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    final Map<ParserKey, TypeParser> typeParsers = new HashMap<ParserKey, TypeParser>();

    public Parser() {
        this.registerTypeParser(Schema.BOOLEAN_SCHEMA, new BooleanParser());
        this.registerTypeParser(Schema.BOOLEAN_SCHEMA, new BooleanParser());
        this.registerTypeParser(Schema.FLOAT32_SCHEMA, new Float32TypeParser());
        this.registerTypeParser(Schema.FLOAT64_SCHEMA, new Float64TypeParser());
        this.registerTypeParser(Schema.INT8_SCHEMA, new Int8TypeParser());
        this.registerTypeParser(Schema.INT16_SCHEMA, new Int16TypeParser());
        this.registerTypeParser(Schema.INT32_SCHEMA, new Int32TypeParser());
        this.registerTypeParser(Schema.INT64_SCHEMA, new Int64TypeParser());
        this.registerTypeParser(Schema.STRING_SCHEMA, new StringTypeParser());
        this.registerTypeParser(Decimal.schema((int)1), new DecimalTypeParser());
        this.registerTypeParser(Date.SCHEMA, new DateTypeParser());
        this.registerTypeParser(Time.SCHEMA, new TimeTypeParser());
        this.registerTypeParser(Timestamp.SCHEMA, new TimestampTypeParser());
    }

    public final void registerTypeParser(Schema schema, TypeParser typeParser) {
        Preconditions.checkNotNull(schema, "schema cannot be null.");
        Preconditions.checkNotNull(typeParser, "typeParser cannot be null.");
        this.typeParsers.put(new ParserKey(schema), typeParser);
    }

    public Object parseString(Schema schema, String input) {
        this.checkSchemaAndInput(schema, input);
        if (null == input) {
            return null;
        }
        TypeParser parser = this.findParser(schema);
        try {
            Object result = parser.parseString(input, schema);
            return result;
        }
        catch (Exception ex) {
            String message = String.format("Could not parse '%s' to '%s'", input, parser.expectedClass().getSimpleName());
            throw new DataException(message, (Throwable)ex);
        }
    }

    void checkSchemaAndInput(Schema schema, Object input) {
        Preconditions.checkNotNull(schema, "schema cannot be null");
        if (!schema.isOptional()) {
            Preconditions.checkNotNull(input, "schema is not optional so input cannot be null.");
        }
    }

    TypeParser findParser(Schema schema) {
        ParserKey parserKey = new ParserKey(schema);
        TypeParser parser = this.typeParsers.get(parserKey);
        if (null == parser) {
            throw new UnsupportedOperationException(String.format("Schema %s(%s) is not supported", schema.type(), schema.name()));
        }
        return parser;
    }

    public Object parseJsonNode(Schema schema, JsonNode input) {
        Struct result;
        this.checkSchemaAndInput(schema, input);
        if (null == input || input.isNull()) {
            return null;
        }
        log.trace("parseJsonNode() - schema.type() = {}", (Object)schema.type());
        if (Schema.Type.STRUCT == schema.type()) {
            LinkedHashSet jsonFieldNames;
            Sets.SetView difference;
            Struct struct = new Struct(schema);
            Preconditions.checkState(input.isObject(), "struct schemas require a ObjectNode to be supplied for input.");
            log.trace("parseJsonNode() - Processing as struct.");
            HashSet<String> processedFields = Sets.newHashSetWithExpectedSize(schema.fields().size());
            for (Field field : schema.fields()) {
                log.trace("parseJsonNode() - Processing field '{}:{}'", (Object)schema.name(), (Object)field.name());
                JsonNode fieldInput = input.findValue(field.name());
                try {
                    Object convertedValue = this.parseJsonNode(field.schema(), fieldInput);
                    struct.put(field, convertedValue);
                }
                catch (Exception ex) {
                    throw new DataException(String.format("Exception thrown while processing %s:%s", schema.name(), field.name()), (Throwable)ex);
                }
                processedFields.add(field.name());
            }
            if (log.isTraceEnabled() && !(difference = Sets.difference(jsonFieldNames = Sets.newLinkedHashSet(ImmutableList.copyOf(input.fieldNames())), processedFields)).isEmpty()) {
                log.trace("parseJsonNode() - Unprocessed fields for {}:\n{}", (Object)schema.name(), (Object)Joiner.on('\n').join(difference));
            }
            result = struct;
        } else if (Schema.Type.ARRAY == schema.type()) {
            Preconditions.checkState(input.isArray(), "array schemas require a ArrayNode to be supplied for input.");
            log.trace("parseJsonNode() - Processing as array.");
            ArrayList<Object> array = new ArrayList<Object>();
            Iterator arrayIterator = input.iterator();
            int index = 0;
            while (arrayIterator.hasNext()) {
                log.trace("parseJsonNode() - Processing index {}", (Object)index);
                JsonNode arrayInput = (JsonNode)arrayIterator.next();
                try {
                    Object arrayResult = this.parseJsonNode(schema.valueSchema(), arrayInput);
                    array.add(arrayResult);
                }
                catch (Exception ex) {
                    throw new DataException(String.format("Exception thrown while processing index %s", index), (Throwable)ex);
                }
                ++index;
            }
            result = array;
        } else if (Schema.Type.MAP == schema.type()) {
            Preconditions.checkState(input.isObject(), "map schemas require a ObjectNode to be supplied for input.");
            log.trace("parseJsonNode() - Processing as map.");
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Iterator fieldNameIterator = input.fieldNames();
            while (fieldNameIterator.hasNext()) {
                Object mapValue;
                Object mapKey;
                String fieldName = (String)fieldNameIterator.next();
                JsonNode fieldInput = input.findValue(fieldName);
                log.trace("parseJsonNode() - Processing key. Key='{}'", (Object)fieldName);
                try {
                    mapKey = this.parseString(schema.keySchema(), fieldName);
                }
                catch (Exception ex) {
                    throw new DataException(String.format("Exception thrown while parsing key. Key='%s'", fieldName), (Throwable)ex);
                }
                log.trace("parseJsonNode() - Processing value. Key='{}'", (Object)fieldName);
                try {
                    mapValue = this.parseJsonNode(schema.keySchema(), fieldInput);
                }
                catch (Exception ex) {
                    throw new DataException(String.format("Exception thrown while parsing value. Key='%s'", fieldName), (Throwable)ex);
                }
                map.put(mapKey, mapValue);
            }
            result = map;
        } else {
            TypeParser parser = this.findParser(schema);
            try {
                result = parser.parseJsonNode(input, schema);
            }
            catch (Exception ex) {
                String message = String.format("Could not parse '%s' to %s", input, parser.expectedClass().getSimpleName());
                throw new DataException(message, (Throwable)ex);
            }
        }
        return result;
    }
}

