/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.kafka.connect.utils.config.ConfigUtils;
import com.github.jcustenborder.repackaged.com.google.common.base.MoreObjects;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;

public class ValidEnum
implements ConfigDef.Validator {
    final Set<String> validEnums;
    final Class<?> enumClass;

    public static ValidEnum of(Class<?> enumClass, String ... excludes) {
        return new ValidEnum(enumClass, excludes);
    }

    private ValidEnum(Class<?> enumClass, String ... excludes) {
        Preconditions.checkNotNull(enumClass, "enumClass cannot be null");
        Preconditions.checkState(enumClass.isEnum(), "enumClass must be an enum.");
        LinkedHashSet<String> validEnums = new LinkedHashSet<String>();
        for (Object o : enumClass.getEnumConstants()) {
            String key = o.toString();
            validEnums.add(key);
        }
        validEnums.removeAll(Arrays.asList(excludes));
        this.validEnums = validEnums;
        this.enumClass = enumClass;
    }

    public void ensureValid(String s, Object o) {
        Preconditions.checkState(this.validEnums.contains(o), "'%s' is not a valid value for %s. Valid values are %s.", o, (Object)this.enumClass.getSimpleName(), (Object)ConfigUtils.enumValues(this.enumClass));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("enum", this.enumClass.getSimpleName()).add("allowed", this.validEnums).toString();
    }
}

