/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(StructSerializationModule.class);

    public StructSerializationModule() {
        this.addSerializer(Struct.class, new Serializer());
        this.addDeserializer(Struct.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Struct> {
        Deserializer() {
        }

        public Struct deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = (Storage)jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<Struct> {
        Serializer() {
        }

        public void serialize(Struct struct, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            struct.validate();
            Storage result = new Storage();
            result.schema = struct.schema();
            result.fieldValues = new ArrayList<FieldValue>();
            for (Field field : struct.schema().fields()) {
                FieldValue fieldValue = new FieldValue();
                fieldValue.name = field.name();
                fieldValue.schema = field.schema();
                fieldValue.value(struct.get(field));
                result.fieldValues.add(fieldValue);
            }
            jsonGenerator.writeObject((Object)result);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class FieldValue {
        String name;
        Schema schema;
        private Object storage;
        private Struct struct;

        void value(Object value) {
            log.trace("value(Object) - name = '{}', schema.type() = {}", (Object)this.name, (Object)this.schema.type());
            if (value != null) {
                switch (this.schema.type()) {
                    case STRUCT: {
                        Preconditions.checkState((boolean)(value instanceof Struct), (Object)"value must be a struct.");
                        this.struct = (Struct)value;
                        break;
                    }
                    default: {
                        this.storage = value;
                    }
                }
            }
        }

        Object value() {
            Object result;
            log.trace("value() - name = '{}'", (Object)this.name);
            switch (this.schema.type()) {
                case STRUCT: {
                    result = this.struct;
                    break;
                }
                default: {
                    result = ValueHelper.value(this.schema, this.storage);
                }
            }
            return result;
        }
    }

    public static class Storage {
        public Schema schema;
        public List<FieldValue> fieldValues;

        public Struct build() {
            Struct struct = new Struct(this.schema);
            for (FieldValue fieldValue : this.fieldValues) {
                struct.put(fieldValue.name, fieldValue.value());
            }
            struct.validate();
            return struct;
        }
    }
}

