/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.GenericAssertions;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.junit.jupiter.api.Assertions;

public class AssertSchema {
    private AssertSchema() {
    }

    public static void assertSchema(Schema expected, Schema actual) {
        AssertSchema.assertSchema(expected, actual, null);
    }

    public static void assertSchema(Schema expected, Schema actual, String message) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should not be null."));
            return;
        }
        Assertions.assertNotNull((Object)expected, (String)(prefix + "expected schema should not be null."));
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual schema should not be null."));
        Assertions.assertEquals((Object)expected.name(), (Object)actual.name(), (String)(prefix + "schema.name() should match."));
        Assertions.assertEquals((Object)expected.type(), (Object)actual.type(), (String)(prefix + "schema.type() should match."));
        Assertions.assertEquals((Object)expected.defaultValue(), (Object)actual.defaultValue(), (String)(prefix + "schema.defaultValue() should match."));
        Assertions.assertEquals((Object)expected.isOptional(), (Object)actual.isOptional(), (String)(prefix + "schema.isOptional() should match."));
        Assertions.assertEquals((Object)expected.doc(), (Object)actual.doc(), (String)(prefix + "schema.doc() should match."));
        Assertions.assertEquals((Integer)expected.version(), (Integer)actual.version(), (String)(prefix + "schema.version() should match."));
        GenericAssertions.assertMap(expected.parameters(), actual.parameters(), prefix + "schema.parameters() should match.");
        if (null != expected.defaultValue()) {
            Assertions.assertNotNull((Object)actual.defaultValue(), (String)"actual.defaultValue() should not be null.");
            Class expectedType = null;
            switch (expected.type()) {
                case INT8: {
                    expectedType = Byte.class;
                    break;
                }
                case INT16: {
                    expectedType = Short.class;
                    break;
                }
                case INT32: {
                    expectedType = Integer.class;
                    break;
                }
                case INT64: {
                    expectedType = Long.class;
                    break;
                }
                case FLOAT32: {
                    expectedType = Float.class;
                    break;
                }
                case FLOAT64: {
                    expectedType = Float.class;
                    break;
                }
            }
            if (null != expectedType) {
                Assertions.assertTrue((boolean)actual.defaultValue().getClass().isAssignableFrom(expectedType), (String)String.format("actual.defaultValue() should be a %s", expectedType.getSimpleName()));
            }
        }
        switch (expected.type()) {
            case ARRAY: {
                AssertSchema.assertSchema(expected.valueSchema(), actual.valueSchema(), message + "valueSchema does not match.");
                break;
            }
            case MAP: {
                AssertSchema.assertSchema(expected.keySchema(), actual.keySchema(), message + "keySchema does not match.");
                AssertSchema.assertSchema(expected.valueSchema(), actual.valueSchema(), message + "valueSchema does not match.");
                break;
            }
            case STRUCT: {
                List expectedFields = expected.fields();
                List actualFields = actual.fields();
                Assertions.assertEquals((int)expectedFields.size(), (int)actualFields.size(), (String)(prefix + "Number of fields do not match."));
                for (int i = 0; i < expectedFields.size(); ++i) {
                    Field expectedField = (Field)expectedFields.get(i);
                    Field actualField = (Field)actualFields.get(i);
                    AssertSchema.assertField(expectedField, actualField, "index " + i);
                }
                break;
            }
        }
    }

    public static void assertField(Field expected, Field actual, String message) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertEquals((Object)expected.name(), (Object)actual.name(), (String)(prefix + "name does not match"));
        Assertions.assertEquals((int)expected.index(), (int)actual.index(), (String)(prefix + "name does not match"));
        AssertSchema.assertSchema(expected.schema(), actual.schema(), prefix + "schema does not match");
    }

    public static void assertField(Field expected, Field actual) {
        AssertSchema.assertField(expected, actual, null);
    }
}

