/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePlugin
implements Plugin {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final ImmutableList<Notes.Section> sections;
    private final String introduction;
    private final String pluginName;
    private final String pluginOwner;
    private final ImmutableList<Plugin.Transformation> transformations;
    private final ImmutableList<Plugin.SinkConnector> sinkConnectors;
    private final ImmutableList<Plugin.SourceConnector> sourceConnectors;
    private final ImmutableList<Plugin.Converter> converters;
    private final ImmutableList<Plugin.ConfigProvider> configProviders;

    private ImmutablePlugin(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable ImmutableList<Notes.Section> sections, String introduction, String pluginName, String pluginOwner, ImmutableList<Plugin.Transformation> transformations, ImmutableList<Plugin.SinkConnector> sinkConnectors, ImmutableList<Plugin.SourceConnector> sourceConnectors, ImmutableList<Plugin.Converter> converters, ImmutableList<Plugin.ConfigProvider> configProviders) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.sections = sections;
        this.introduction = introduction;
        this.pluginName = pluginName;
        this.pluginOwner = pluginOwner;
        this.transformations = transformations;
        this.sinkConnectors = sinkConnectors;
        this.sourceConnectors = sourceConnectors;
        this.converters = converters;
        this.configProviders = configProviders;
    }

    @Override
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Nullable
    public ImmutableList<Notes.Section> getSections() {
        return this.sections;
    }

    @Override
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public String getPluginOwner() {
        return this.pluginOwner;
    }

    public ImmutableList<Plugin.Transformation> getTransformations() {
        return this.transformations;
    }

    public ImmutableList<Plugin.SinkConnector> getSinkConnectors() {
        return this.sinkConnectors;
    }

    public ImmutableList<Plugin.SourceConnector> getSourceConnectors() {
        return this.sourceConnectors;
    }

    public ImmutableList<Plugin.Converter> getConverters() {
        return this.converters;
    }

    public ImmutableList<Plugin.ConfigProvider> getConfigProviders() {
        return this.configProviders;
    }

    public final ImmutablePlugin withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutablePlugin(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSections(Notes.Section ... elements) {
        if (elements == null) {
            return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, null, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, (ImmutableList<Notes.Section>)newValue, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSections(@Nullable Iterable<? extends Notes.Section> elements) {
        if (this.sections == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, (ImmutableList<Notes.Section>)newValue, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withIntroduction(String value) {
        String newValue = Objects.requireNonNull(value, "introduction");
        if (this.introduction.equals(newValue)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, newValue, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withPluginName(String value) {
        String newValue = Objects.requireNonNull(value, "pluginName");
        if (this.pluginName.equals(newValue)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, newValue, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withPluginOwner(String value) {
        String newValue = Objects.requireNonNull(value, "pluginOwner");
        if (this.pluginOwner.equals(newValue)) {
            return this;
        }
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, newValue, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withTransformations(Plugin.Transformation ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, (ImmutableList<Plugin.Transformation>)newValue, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withTransformations(Iterable<? extends Plugin.Transformation> elements) {
        if (this.transformations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, (ImmutableList<Plugin.Transformation>)newValue, this.sinkConnectors, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSinkConnectors(Plugin.SinkConnector ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, (ImmutableList<Plugin.SinkConnector>)newValue, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
        if (this.sinkConnectors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, (ImmutableList<Plugin.SinkConnector>)newValue, this.sourceConnectors, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSourceConnectors(Plugin.SourceConnector ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, (ImmutableList<Plugin.SourceConnector>)newValue, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withSourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
        if (this.sourceConnectors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, (ImmutableList<Plugin.SourceConnector>)newValue, this.converters, this.configProviders);
    }

    public final ImmutablePlugin withConverters(Plugin.Converter ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, (ImmutableList<Plugin.Converter>)newValue, this.configProviders);
    }

    public final ImmutablePlugin withConverters(Iterable<? extends Plugin.Converter> elements) {
        if (this.converters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, (ImmutableList<Plugin.Converter>)newValue, this.configProviders);
    }

    public final ImmutablePlugin withConfigProviders(Plugin.ConfigProvider ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, (ImmutableList<Plugin.ConfigProvider>)newValue);
    }

    public final ImmutablePlugin withConfigProviders(Iterable<? extends Plugin.ConfigProvider> elements) {
        if (this.configProviders == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections, this.introduction, this.pluginName, this.pluginOwner, this.transformations, this.sinkConnectors, this.sourceConnectors, this.converters, (ImmutableList<Plugin.ConfigProvider>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlugin && this.equalTo((ImmutablePlugin)another);
    }

    private boolean equalTo(ImmutablePlugin another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.sections, another.sections) && this.introduction.equals(another.introduction) && this.pluginName.equals(another.pluginName) && this.pluginOwner.equals(another.pluginOwner) && this.transformations.equals(another.transformations) && this.sinkConnectors.equals(another.sinkConnectors) && this.sourceConnectors.equals(another.sourceConnectors) && this.converters.equals(another.converters) && this.configProviders.equals(another.configProviders);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warning);
        h += (h << 5) + Objects.hashCode(this.tip);
        h += (h << 5) + Objects.hashCode(this.important);
        h += (h << 5) + Objects.hashCode(this.danger);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.sections);
        h += (h << 5) + this.introduction.hashCode();
        h += (h << 5) + this.pluginName.hashCode();
        h += (h << 5) + this.pluginOwner.hashCode();
        h += (h << 5) + this.transformations.hashCode();
        h += (h << 5) + this.sinkConnectors.hashCode();
        h += (h << 5) + this.sourceConnectors.hashCode();
        h += (h << 5) + this.converters.hashCode();
        h += (h << 5) + this.configProviders.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Plugin").omitNullValues().add("warning", (Object)this.warning).add("tip", (Object)this.tip).add("important", (Object)this.important).add("danger", (Object)this.danger).add("note", (Object)this.note).add("title", (Object)this.title).add("description", (Object)this.description).add("icon", (Object)this.icon).add("sections", this.sections).add("introduction", (Object)this.introduction).add("pluginName", (Object)this.pluginName).add("pluginOwner", (Object)this.pluginOwner).add("transformations", this.transformations).add("sinkConnectors", this.sinkConnectors).add("sourceConnectors", this.sourceConnectors).add("converters", this.converters).add("configProviders", this.configProviders).toString();
    }

    public static ImmutablePlugin copyOf(Plugin instance) {
        if (instance instanceof ImmutablePlugin) {
            return (ImmutablePlugin)instance;
        }
        return ImmutablePlugin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INTRODUCTION = 1L;
        private static final long INIT_BIT_PLUGIN_NAME = 2L;
        private static final long INIT_BIT_PLUGIN_OWNER = 4L;
        private long initBits = 7L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        private ImmutableList.Builder<Notes.Section> sections = null;
        @Nullable
        private String introduction;
        @Nullable
        private String pluginName;
        @Nullable
        private String pluginOwner;
        private ImmutableList.Builder<Plugin.Transformation> transformations = ImmutableList.builder();
        private ImmutableList.Builder<Plugin.SinkConnector> sinkConnectors = ImmutableList.builder();
        private ImmutableList.Builder<Plugin.SourceConnector> sourceConnectors = ImmutableList.builder();
        private ImmutableList.Builder<Plugin.Converter> converters = ImmutableList.builder();
        private ImmutableList.Builder<Plugin.ConfigProvider> configProviders = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Notes instance;
            long bits = 0L;
            if (object instanceof Notes) {
                List<Notes.Section> sectionsValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String warningValue;
                String descriptionValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((sectionsValue = instance.getSections()) != null) {
                    this.addAllSections(sectionsValue);
                }
                if ((bits & 1L) == 0L) {
                    String introductionValue = instance.getIntroduction();
                    if (introductionValue != null) {
                        this.introduction(introductionValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Plugin) {
                instance = (Plugin)object;
                this.addAllConfigProviders(instance.getConfigProviders());
                this.addAllSourceConnectors(instance.getSourceConnectors());
                this.pluginName(instance.getPluginName());
                this.addAllTransformations(instance.getTransformations());
                this.addAllSinkConnectors(instance.getSinkConnectors());
                this.addAllConverters(instance.getConverters());
                if ((bits & 1L) == 0L) {
                    String introductionValue = instance.getIntroduction();
                    if (introductionValue != null) {
                        this.introduction(introductionValue);
                    }
                    bits |= 1L;
                }
                this.pluginOwner(instance.getPluginOwner());
            }
        }

        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section element) {
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section ... elements) {
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sections(@Nullable Iterable<? extends Notes.Section> elements) {
            if (elements == null) {
                this.sections = null;
                return this;
            }
            this.sections = ImmutableList.builder();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Notes.Section> elements) {
            Objects.requireNonNull(elements, "sections element");
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder introduction(String introduction) {
            this.introduction = Objects.requireNonNull(introduction, "introduction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginName(String pluginName) {
            this.pluginName = Objects.requireNonNull(pluginName, "pluginName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginOwner(String pluginOwner) {
            this.pluginOwner = Objects.requireNonNull(pluginOwner, "pluginOwner");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformations(Plugin.Transformation element) {
            this.transformations.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformations(Plugin.Transformation ... elements) {
            this.transformations.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transformations(Iterable<? extends Plugin.Transformation> elements) {
            this.transformations = ImmutableList.builder();
            return this.addAllTransformations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransformations(Iterable<? extends Plugin.Transformation> elements) {
            this.transformations.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSinkConnectors(Plugin.SinkConnector element) {
            this.sinkConnectors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSinkConnectors(Plugin.SinkConnector ... elements) {
            this.sinkConnectors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
            this.sinkConnectors = ImmutableList.builder();
            return this.addAllSinkConnectors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSinkConnectors(Iterable<? extends Plugin.SinkConnector> elements) {
            this.sinkConnectors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceConnectors(Plugin.SourceConnector element) {
            this.sourceConnectors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSourceConnectors(Plugin.SourceConnector ... elements) {
            this.sourceConnectors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
            this.sourceConnectors = ImmutableList.builder();
            return this.addAllSourceConnectors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSourceConnectors(Iterable<? extends Plugin.SourceConnector> elements) {
            this.sourceConnectors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConverters(Plugin.Converter element) {
            this.converters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConverters(Plugin.Converter ... elements) {
            this.converters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder converters(Iterable<? extends Plugin.Converter> elements) {
            this.converters = ImmutableList.builder();
            return this.addAllConverters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConverters(Iterable<? extends Plugin.Converter> elements) {
            this.converters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConfigProviders(Plugin.ConfigProvider element) {
            this.configProviders.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConfigProviders(Plugin.ConfigProvider ... elements) {
            this.configProviders.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configProviders(Iterable<? extends Plugin.ConfigProvider> elements) {
            this.configProviders = ImmutableList.builder();
            return this.addAllConfigProviders(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConfigProviders(Iterable<? extends Plugin.ConfigProvider> elements) {
            this.configProviders.addAll(elements);
            return this;
        }

        public ImmutablePlugin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlugin(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.sections == null ? null : this.sections.build(), this.introduction, this.pluginName, this.pluginOwner, this.transformations.build(), this.sinkConnectors.build(), this.sourceConnectors.build(), this.converters.build(), this.configProviders.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("introduction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pluginName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pluginOwner");
            }
            return "Cannot build Plugin, some of required attributes are not set " + attributes;
        }
    }
}

