/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.AssertSchema;
import com.github.jcustenborder.kafka.connect.utils.AssertStruct;
import com.github.jcustenborder.kafka.connect.utils.GenericAssertions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.jupiter.api.Assertions;
import shaded.com.google.common.collect.LinkedHashMultimap;

public class AssertConnectRecord {
    public static void assertValue(Object expected, Object actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should be null."));
        if (expected instanceof Struct) {
            Assertions.assertTrue((boolean)(actual instanceof Struct), (String)(prefix + "actual should be a Struct."));
            Struct expectedStruct = (Struct)expected;
            Struct actualStruct = (Struct)actual;
            AssertStruct.assertStruct(expectedStruct, actualStruct, message);
        } else if (expected instanceof Map) {
            Assertions.assertTrue((boolean)(actual instanceof Map), (String)(prefix + "actual should be a Map."));
            Map expectedMap = (Map)expected;
            Map actualMap = (Map)actual;
            GenericAssertions.assertMap(expectedMap, actualMap, message);
        } else if (expected instanceof byte[]) {
            Assertions.assertTrue((boolean)(actual instanceof byte[]), (String)(prefix + "actual should be a byte[]."));
            byte[] expectedByteArray = (byte[])expected;
            byte[] actualByteArray = (byte[])actual;
            Assertions.assertArrayEquals((byte[])expectedByteArray, (byte[])actualByteArray, (String)(prefix + "actual does not match"));
        } else {
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
    }

    public static void assertRecord(ConnectRecord expected, ConnectRecord actual) {
        AssertConnectRecord.assertRecord(expected, actual, null);
    }

    public static void assertRecord(ConnectRecord expected, ConnectRecord actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should not be null."));
        Assertions.assertEquals((Object)expected.kafkaPartition(), (Object)actual.kafkaPartition(), (String)(prefix + "kafkaPartition() does not match."));
        Assertions.assertEquals((Object)expected.topic(), (Object)actual.topic(), (String)(prefix + "topic() does not match."));
        Assertions.assertEquals((Object)expected.timestamp(), (Object)actual.timestamp(), (String)(prefix + "timestamp() does not match."));
        AssertSchema.assertSchema(expected.keySchema(), actual.keySchema(), prefix + "keySchema() does not match");
        AssertConnectRecord.assertValue(expected.key(), actual.key(), prefix + "key() does not match.");
        AssertSchema.assertSchema(expected.valueSchema(), actual.valueSchema(), prefix + "valueSchema() does not match");
        AssertConnectRecord.assertValue(expected.value(), actual.value(), prefix + "value() does not match.");
        AssertConnectRecord.assertHeaders(expected.headers(), actual.headers(), prefix + "headers() does not match.");
    }

    public static void assertSourceRecord(SourceRecord expected, SourceRecord actual) {
        AssertConnectRecord.assertSourceRecord(expected, actual, null);
    }

    public static void assertSourceRecord(SourceRecord expected, SourceRecord actual, String message) {
        String prefix = null != message ? message + ": " : "";
        AssertConnectRecord.assertRecord((ConnectRecord)expected, (ConnectRecord)actual, message);
        GenericAssertions.assertMap(expected.sourceOffset(), actual.sourceOffset(), prefix + "sourceOffset() does not match.");
        GenericAssertions.assertMap(expected.sourcePartition(), actual.sourcePartition(), prefix + "sourcePartition() does not match.");
    }

    public static void assertHeader(Header expected, Header actual) {
        AssertConnectRecord.assertHeader(expected, actual, null);
    }

    public static void assertHeader(Header expected, Header actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should not be null."));
        Assertions.assertEquals((Object)expected.key(), (Object)expected.key(), (String)(prefix + "key() does not match."));
        AssertConnectRecord.assertValue(expected.value(), actual.value(), prefix + "value() does not match.");
        AssertSchema.assertSchema(expected.schema(), actual.schema(), prefix + "schema() does not match.");
    }

    public static void assertHeaders(Headers expected, Headers actual) {
        AssertConnectRecord.assertHeaders(expected, actual, null);
    }

    public static void assertHeaders(Headers expected, Headers actual, String message) {
        String prefix;
        String string = prefix = null != message ? message + ": " : "";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
        }
        Assertions.assertNotNull((Object)actual, (String)(prefix + "actual should not be null."));
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)(prefix + "size() should match."));
        LinkedHashMultimap expectedHeaders = LinkedHashMultimap.create();
        for (Object header : expected) {
            expectedHeaders.put((Object)header.key(), header);
        }
        LinkedHashMultimap actualHeaders = LinkedHashMultimap.create();
        for (Header header : actual) {
            actualHeaders.put((Object)header.key(), (Object)header);
        }
        Set expectedKeys = StreamSupport.stream(expected.spliterator(), false).map(Header::key).collect(Collectors.toSet());
        for (String key : expectedKeys) {
            List expectedHeaderSet = expectedHeaders.get((Object)key).stream().collect(Collectors.toList());
            List actualHeaderSet = actualHeaders.get((Object)key).stream().collect(Collectors.toList());
            if (null == expectedHeaderSet) {
                Assertions.assertNull(actualHeaderSet, (String)(prefix + "header \"" + key + "\" should be null."));
                continue;
            }
            Assertions.assertNotNull(actualHeaderSet, (String)(prefix + "header \"" + key + "\" should be null."));
            Assertions.assertEquals((int)expectedHeaderSet.size(), (int)actualHeaderSet.size(), (String)"length does not match.");
            for (int i = 0; i < expectedHeaderSet.size(); ++i) {
                AssertConnectRecord.assertHeader((Header)expectedHeaderSet.get(i), (Header)actualHeaderSet.get(i), String.format("%sheader for key '%s' does not match at index %s", prefix, key, i));
            }
        }
    }
}

