/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationDanger;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationImportant;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationNote;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationTip;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationWarning;
import com.github.jcustenborder.kafka.connect.utils.config.Title;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateConfigDef;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.transforms.Transformation;

public class ConnectorTemplate {
    private final String title;
    private final String description;
    private final String className;
    private final String warning;
    private final String tip;
    private final String important;
    private final String danger;
    private final String note;
    private final String simpleName;
    private final String diagramFileName;
    private final TemplateConfigDef config;

    public ConnectorTemplate(Class<?> cls) {
        ConfigDef configDef;
        block4: {
            this.title = ConnectorTemplate.title(cls);
            this.description = ConnectorTemplate.description(cls);
            this.className = cls.getName();
            this.simpleName = cls.getSimpleName();
            this.diagramFileName = this.simpleName + ".svg";
            this.warning = ConnectorTemplate.warning(cls);
            this.tip = ConnectorTemplate.tip(cls);
            this.important = ConnectorTemplate.important(cls);
            this.danger = ConnectorTemplate.danger(cls);
            this.note = ConnectorTemplate.note(cls);
            try {
                if (Connector.class.isAssignableFrom(cls)) {
                    Connector connector = (Connector)cls.newInstance();
                    configDef = connector.config();
                    break block4;
                }
                if (Transformation.class.isAssignableFrom(cls)) {
                    Transformation transformation = (Transformation)cls.newInstance();
                    configDef = transformation.config();
                    break block4;
                }
                throw new UnsupportedOperationException(String.format("Class %s is not supported", cls.getName()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        this.config = TemplateConfigDef.from(configDef);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getNote() {
        return this.note;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public TemplateConfigDef getConfig() {
        return this.config;
    }

    protected static String title(Class<?> aClass) {
        Title annotation = aClass.getAnnotation(Title.class);
        String result = null != annotation ? annotation.value() : aClass.getSimpleName();
        return result;
    }

    protected static String description(Class<?> aClass) {
        Description annotation = aClass.getAnnotation(Description.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    protected static String danger(Class<?> aClass) {
        DocumentationDanger annotation = aClass.getAnnotation(DocumentationDanger.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    protected static String important(Class<?> aClass) {
        DocumentationImportant annotation = aClass.getAnnotation(DocumentationImportant.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    protected static String tip(Class<?> aClass) {
        DocumentationTip annotation = aClass.getAnnotation(DocumentationTip.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    protected static String note(Class<?> aClass) {
        DocumentationNote annotation = aClass.getAnnotation(DocumentationNote.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    protected static String warning(Class<?> aClass) {
        DocumentationWarning annotation = aClass.getAnnotation(DocumentationWarning.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getDiagramFileName() {
        return this.diagramFileName;
    }
}

