/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationDanger;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationImportant;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationNote;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationTip;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationWarning;
import com.github.jcustenborder.kafka.connect.utils.config.Title;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateConfigDef;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateInput {
    private static final Logger log = LoggerFactory.getLogger(TemplateInput.class);
    private String title;
    private String description;
    private String className;
    private String warning;
    private String tip;
    private String important;
    private String danger;
    private String note;
    private TemplateConfigDef config;

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getNote() {
        return this.note;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public TemplateConfigDef getConfig() {
        return this.config;
    }

    private static String title(Class<?> aClass) {
        Title annotation = aClass.getAnnotation(Title.class);
        String result = null != annotation ? annotation.value() : aClass.getSimpleName();
        return result;
    }

    private static String description(Class<?> aClass) {
        Description annotation = aClass.getAnnotation(Description.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String danger(Class<?> aClass) {
        DocumentationDanger annotation = aClass.getAnnotation(DocumentationDanger.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String important(Class<?> aClass) {
        DocumentationImportant annotation = aClass.getAnnotation(DocumentationImportant.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String tip(Class<?> aClass) {
        DocumentationTip annotation = aClass.getAnnotation(DocumentationTip.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String note(Class<?> aClass) {
        DocumentationNote annotation = aClass.getAnnotation(DocumentationNote.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String warning(Class<?> aClass) {
        DocumentationWarning annotation = aClass.getAnnotation(DocumentationWarning.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static void populateTemplate(Class<?> aClass, TemplateInput result, ConfigDef config) {
        result.className = aClass.getName();
        result.title = TemplateInput.title(aClass);
        result.description = TemplateInput.description(aClass);
        result.tip = TemplateInput.tip(aClass);
        result.warning = TemplateInput.warning(aClass);
        result.important = TemplateInput.important(aClass);
        result.danger = TemplateInput.danger(aClass);
        result.config = TemplateConfigDef.from(config);
    }

    public static TemplateInput fromTransformation(Class<? extends Transformation> transform) throws IllegalAccessException, InstantiationException {
        TemplateInput result = new TemplateInput();
        Transformation sourceConnector = transform.newInstance();
        ConfigDef config = sourceConnector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        TemplateInput.populateTemplate(transform, result, config);
        return result;
    }

    public static TemplateInput fromConnector(Class<? extends Connector> connectorClass) throws IllegalAccessException, InstantiationException {
        TemplateInput result = new TemplateInput();
        Connector connector = connectorClass.newInstance();
        ConfigDef config = connector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        TemplateInput.populateTemplate(connectorClass, result, config);
        return result;
    }

    public static void checkLength(Map<String, Integer> columnLengths, String name, Object value) {
        int current;
        int length = (value != null ? value.toString().length() : 0) + 2;
        if (length > (current = columnLengths.getOrDefault(name, 0).intValue())) {
            columnLengths.put(name, length);
        }
    }
}

