/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.model;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;

public class Configuration {
    final List<Item> requiredConfigs;
    final List<Group> groups;

    public List<Group> getGroups() {
        return this.groups;
    }

    private Configuration(Collection<Item> configs) {
        this.requiredConfigs = configs.stream().filter(Item::isRequired).collect(Collectors.toList());
        LinkedListMultimap groupToItem = LinkedListMultimap.create();
        for (Item item : configs) {
            groupToItem.put((Object)item.group, (Object)item);
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String group : groupToItem.keySet()) {
            Collection items = groupToItem.get((Object)group);
            groups.add(new Group(group, new ArrayList<Item>(items)));
        }
        Collections.sort(groups);
        this.groups = ImmutableList.copyOf(groups);
    }

    public static Configuration from(ConfigDef config) {
        List<Item> configs = config.configKeys().entrySet().stream().sorted((k1, k2) -> {
            if (!((ConfigDef.ConfigKey)k1.getValue()).hasDefault() && ((ConfigDef.ConfigKey)k2.getValue()).hasDefault()) {
                return -1;
            }
            if (!((ConfigDef.ConfigKey)k2.getValue()).hasDefault() && ((ConfigDef.ConfigKey)k1.getValue()).hasDefault()) {
                return 1;
            }
            int cmp = ((ConfigDef.ConfigKey)k1.getValue()).importance.compareTo((Enum)((ConfigDef.ConfigKey)k2.getValue()).importance);
            if (cmp == 0) {
                return ((ConfigDef.ConfigKey)k1.getValue()).name.compareTo(((ConfigDef.ConfigKey)k2.getValue()).name);
            }
            return cmp;
        }).map(entry -> Item.of((ConfigDef.ConfigKey)entry.getValue())).collect(Collectors.toList());
        return new Configuration(configs);
    }

    public List<Item> getRequiredConfigs() {
        return this.requiredConfigs;
    }

    public static class Item {
        public static final String GENERAL_GROUP = "General";
        private final String name;
        private final String importance;
        private final String doc;
        private final String defaultValue;
        private final String validator;
        private final String type;
        private final boolean isRequired;
        private final String group;

        private Item(String name, ConfigDef.Importance importance, String doc, Object defaultValue, ConfigDef.Validator validator, ConfigDef.Type type, boolean isRequired, String group) {
            this.name = name;
            this.importance = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, importance.toString());
            this.doc = !Strings.isNullOrEmpty((String)doc) ? doc : "";
            this.defaultValue = null != defaultValue && ConfigDef.NO_DEFAULT_VALUE != defaultValue ? defaultValue.toString() : "";
            this.validator = null != validator ? validator.toString() : "";
            this.type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString());
            this.isRequired = isRequired;
            this.group = Strings.isNullOrEmpty((String)group) ? GENERAL_GROUP : group;
        }

        public static Item of(ConfigDef.ConfigKey configKey) {
            return new Item(configKey.name, configKey.importance, configKey.documentation, configKey.defaultValue, configKey.validator, configKey.type, !configKey.hasDefault(), configKey.group);
        }

        public String getName() {
            return this.name;
        }

        public String getImportance() {
            return this.importance;
        }

        public String getDoc() {
            return this.doc;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getValidator() {
            return this.validator;
        }

        public String getType() {
            return this.type;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }

    public static class Group
    implements Comparable<Group> {
        final String name;
        final List<Item> items;

        public Group(String name, List<Item> items) {
            this.name = name;
            this.items = items;
        }

        public String getName() {
            return this.name;
        }

        public List<Item> getItems() {
            return this.items;
        }

        @Override
        public int compareTo(Group that) {
            if (null == that) {
                return 1;
            }
            String thisName = "General".equalsIgnoreCase(this.name) ? "ZZZZZZZZZZZ" : this.name;
            String thatName = "General".equalsIgnoreCase(that.name) ? "ZZZZZZZZZZZ" : that.name;
            return thisName.compareToIgnoreCase(thatName);
        }
    }
}

