/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates.rst;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jcustenborder.kafka.connect.utils.templates.TemplateHelper;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Configurable;
import com.github.jcustenborder.kafka.connect.utils.templates.model.Example;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class RstTemplateHelper
extends TemplateHelper {
    List<Integer> emphasizeLines(String content) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try (StringReader stringReader = new StringReader(content);
             LineNumberReader reader = new LineNumberReader(stringReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("< Required Configuration >")) continue;
                result.add(reader.getLineNumber());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public String jsonExample(Configurable template) {
        String json;
        StringWriter writer = new StringWriter();
        ObjectNode outputNode = this.createJsonNode(template);
        try {
            json = this.objectMapper.writeValueAsString((Object)outputNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        writer.write(".. code-block:: json");
        writer.write(10);
        writer.write("    :caption: Connect Distributed REST example");
        writer.write(10);
        writer.write("    :name: connector.json");
        writer.write(10);
        List<Integer> emphasizeLines = this.emphasizeLines(json);
        if (!emphasizeLines.isEmpty()) {
            writer.write("    :emphasize-lines: ");
            writer.write(Joiner.on((char)',').join(emphasizeLines));
            writer.write(10);
        }
        writer.write(10);
        writer.write(this.indent(json));
        writer.write(10);
        return writer.toString();
    }

    public String jsonExample(Example example) {
        StringWriter writer = new StringWriter();
        writer.write(".. literalinclude:: " + example.getExampleJsonFile());
        writer.write(10);
        writer.write("    :language: JSON");
        writer.write(10);
        return writer.toString();
    }

    public String propertiesExample(Example example) {
        StringWriter writer = new StringWriter();
        writer.write(".. literalinclude:: " + example.getExamplePropertiesFile());
        writer.write(10);
        writer.write("    :language: properties");
        writer.write(10);
        return writer.toString();
    }

    String indent(String result) {
        StringWriter writer = new StringWriter();
        try (StringReader stringReader = new StringReader(result);
             BufferedReader reader = new BufferedReader(stringReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                ((Writer)writer).write("    ");
                ((Writer)writer).write(line);
                ((Writer)writer).write(10);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return ((Object)writer).toString();
    }

    public String propertiesExample(Configurable template) {
        StringWriter writer = new StringWriter();
        Properties properties = this.createProperties(template);
        try {
            properties.store(writer, "");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String result = writer.toString();
        result = this.indent(result);
        writer = new StringWriter();
        writer.write(".. code-block:: properties");
        writer.write(10);
        writer.write("    :name: connector.properties");
        writer.write(10);
        List<Integer> emphasizeLines = this.emphasizeLines(result);
        if (!emphasizeLines.isEmpty()) {
            writer.write("    :emphasize-lines: ");
            writer.write(Joiner.on((char)',').join(emphasizeLines));
            writer.write(10);
        }
        writer.write(10);
        writer.write(result);
        return writer.toString();
    }
}

