/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import org.apache.kafka.common.config.ConfigDef;

public class TemplateConfigEntry {
    private final String name;
    private final String importance;
    private final String doc;
    private final String defaultValue;
    private final String validator;
    private final String type;
    private final boolean isRequired;

    private TemplateConfigEntry(String name, ConfigDef.Importance importance, String doc, Object defaultValue, ConfigDef.Validator validator, ConfigDef.Type type) {
        this.name = name;
        this.importance = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, importance.toString());
        this.doc = !Strings.isNullOrEmpty((String)doc) ? doc : "";
        this.defaultValue = null != defaultValue ? defaultValue.toString() : "";
        this.validator = null != validator ? validator.toString() : "";
        this.type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, type.toString());
        this.isRequired = null == defaultValue;
    }

    public String name() {
        return this.name;
    }

    public String importance() {
        return this.importance;
    }

    public String doc() {
        return this.doc;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String validator() {
        return this.validator;
    }

    public String type() {
        return this.type;
    }

    public static TemplateConfigEntry of(ConfigDef.ConfigKey configKey) {
        return new TemplateConfigEntry(configKey.name, configKey.importance, configKey.documentation, configKey.defaultValue, configKey.validator, configKey.type);
    }

    public boolean isRequired() {
        return this.isRequired;
    }
}

