/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.TemplateInput;
import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.MarkdownFormatter;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    static Configuration configuration;
    static ClassTemplateLoader loader;
    Reflections reflections;
    List<Class<? extends Transformation>> transformClasses;
    List<Class<? extends Connector>> connectorClasses;
    List<Class<? extends SourceConnector>> sourceConnectorClasses;
    List<Class<? extends SinkConnector>> sinkConnectorClasses;
    final File outputDirectory = new File("target/docs");

    protected List<Schema> schemas() {
        return Arrays.asList(new Schema[0]);
    }

    protected abstract String[] packages();

    @BeforeAll
    public static void loadTemplates() {
        loader = new ClassTemplateLoader(BaseDocumentationTest.class, "templates");
        configuration = new Configuration(Configuration.getVersion());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateLoader((TemplateLoader)loader);
        configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.getVersion()));
    }

    <T> List<Class<? extends T>> list(Class<T> cls) {
        List<Class<T>> classes = this.reflections.getSubTypesOf(cls).stream().filter(aClass -> !Modifier.isAbstract(aClass.getModifiers()) && Modifier.isPublic(aClass.getModifiers())).collect(Collectors.toList());
        classes.sort(Comparator.comparing(Class::getName));
        return classes;
    }

    @BeforeEach
    public void before() throws MalformedURLException {
        log.info("before() - Configuring reflections to use package '{}'", (Object[])this.packages());
        if (null == this.reflections) {
            this.reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).forPackages(this.packages()));
        }
        if (null == this.transformClasses) {
            this.transformClasses = this.list(Transformation.class);
        }
        if (null == this.sourceConnectorClasses) {
            this.sourceConnectorClasses = this.list(SourceConnector.class);
        }
        if (null == this.sinkConnectorClasses) {
            this.sinkConnectorClasses = this.list(SinkConnector.class);
        }
        if (null == this.connectorClasses) {
            this.connectorClasses = new ArrayList<Class<? extends Connector>>(this.sourceConnectorClasses.size() + this.sinkConnectorClasses.size());
            this.connectorClasses.addAll(this.sourceConnectorClasses);
            this.connectorClasses.addAll(this.sinkConnectorClasses);
        }
    }

    protected List<Map.Entry<String, ConfigDef.ConfigKey>> required(ConfigDef configDef) {
        ArrayList entries = new ArrayList();
        for (Map.Entry kvp : configDef.configKeys().entrySet()) {
            if (((ConfigDef.ConfigKey)kvp.getValue()).hasDefault()) continue;
            entries.add(kvp);
        }
        return ImmutableList.copyOf(entries);
    }

    DynamicTest connectorRstTest(Class<? extends Connector> connectorClass, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        return DynamicTest.dynamicTest((String)connectorClass.getSimpleName(), () -> {
            File outputFile = new File(parentDirectory, connectorClass.getSimpleName().toLowerCase() + ".rst");
            TemplateInput input = TemplateInput.fromConnector(connectorClass);
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, input);
            }
        });
    }

    DynamicTest transformRstTest(Class<? extends Transformation> transformationClass, String templateName, File parentDirectory) {
        if (!parentDirectory.isDirectory()) {
            parentDirectory.mkdirs();
        }
        return DynamicTest.dynamicTest((String)transformationClass.getSimpleName(), () -> {
            File outputFile = new File(parentDirectory, transformationClass.getSimpleName().toLowerCase() + ".rst");
            TemplateInput input = TemplateInput.fromTransformation(transformationClass);
            Template template = configuration.getTemplate(templateName);
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, input);
            }
        });
    }

    @TestFactory
    public Stream<DynamicTest> sources() {
        File parentDirectory = new File(this.outputDirectory, "sources");
        String templateName = "rst/source.rst.ftl";
        return this.sourceConnectorClasses.stream().map(aClass -> this.connectorRstTest((Class<? extends Connector>)aClass, "rst/source.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> sinks() {
        File parentDirectory = new File(this.outputDirectory, "sinks");
        String templateName = "rst/sink.rst.ftl";
        return this.sinkConnectorClasses.stream().map(aClass -> this.connectorRstTest((Class<? extends Connector>)aClass, "rst/sink.rst.ftl", parentDirectory));
    }

    void process(Writer writer, Template template, Object input) throws IOException, TemplateException {
        ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)input);
        template.process((Object)variables, writer);
    }

    @TestFactory
    public Stream<DynamicTest> transformations() {
        File parentDirectory = new File(this.outputDirectory, "transformations");
        String templateName = "rst/transformation.rst.ftl";
        return this.transformClasses.stream().map(aClass -> this.transformRstTest((Class<? extends Transformation>)aClass, "rst/transformation.rst.ftl", parentDirectory));
    }

    @TestFactory
    public Stream<DynamicTest> schema() throws IOException {
        List<Schema> schemas;
        File parentDirectory = new File(this.outputDirectory, "schemas");
        if (!parentDirectory.exists()) {
            parentDirectory.mkdirs();
        }
        if (null != (schemas = this.schemas()) && !schemas.isEmpty()) {
            File schemaRstPath = new File(this.outputDirectory, "schemas.rst");
            String schemaRst = "=======\nSchemas\n=======\n\n.. toctree::\n    :maxdepth: 0\n    :caption: Schemas:\n    :glob:\n\n    schemas/*";
            Files.write((CharSequence)"=======\nSchemas\n=======\n\n.. toctree::\n    :maxdepth: 0\n    :caption: Schemas:\n    :glob:\n\n    schemas/*", (File)schemaRstPath, (Charset)Charsets.UTF_8);
        }
        String templateName = "rst/schema.rst.ftl";
        return this.schemas().stream().filter(schema -> !Strings.isNullOrEmpty((String)schema.name())).map(schema -> DynamicTest.dynamicTest((String)String.format("%s.%s", schema.type(), schema.name()), () -> {
            StringBuilder filenameBuilder = new StringBuilder().append(schema.type().toString().toLowerCase());
            if (!Strings.isNullOrEmpty((String)schema.name())) {
                filenameBuilder.append('.').append(schema.name());
            }
            filenameBuilder.append(".rst");
            File outputFile = new File(parentDirectory, filenameBuilder.toString());
            Template template = configuration.getTemplate("rst/schema.rst.ftl");
            log.info("Writing {}", (Object)outputFile);
            LinkedHashMap<String, Integer> lengths = new LinkedHashMap<String, Integer>();
            TemplateInput.checkLength(lengths, "name", "name");
            TemplateInput.checkLength(lengths, "optional", "Optional");
            TemplateInput.checkLength(lengths, "schema", "Schema");
            TemplateInput.checkLength(lengths, "defaultValue", "Default Value");
            TemplateInput.checkLength(lengths, "doc", "Documentation");
            for (Field field : schema.fields()) {
                TemplateInput.checkLength(lengths, "name", field.name());
                TemplateInput.checkLength(lengths, "optional", field.schema().isOptional());
                TemplateInput.checkLength(lengths, "schema", Strings.padEnd((String)field.schema().type().toString(), (int)50, (char)' '));
                TemplateInput.checkLength(lengths, "defaultValue", field.schema().defaultValue());
                TemplateInput.checkLength(lengths, "doc", field.schema().doc());
            }
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)schema, (Object)"lengths", lengths);
                template.process((Object)variables, (Writer)writer);
            }
        }));
    }

    @Test
    public void markdown() throws IOException, IllegalAccessException, InstantiationException {
        try (StringWriter stringWriter = new StringWriter();){
            try (PrintWriter writer = new PrintWriter(stringWriter);){
                ConfigDef configDef;
                Description descriptionAttribute;
                writer.println();
                writer.println("# Configuration");
                writer.println();
                for (Class<? extends Connector> clazz : this.connectorClasses) {
                    if (Modifier.isAbstract(clazz.getModifiers())) {
                        log.trace("Skipping {} because it's abstract.", (Object)clazz.getName());
                        continue;
                    }
                    writer.printf("## %s", clazz.getSimpleName());
                    writer.println();
                    descriptionAttribute = clazz.getAnnotation(Description.class);
                    if (null != descriptionAttribute && !Strings.isNullOrEmpty((String)descriptionAttribute.value())) {
                        writer.println();
                        writer.append(descriptionAttribute.value());
                        writer.println();
                    }
                    writer.println();
                    Connector connector = clazz.newInstance();
                    configDef = connector.config();
                    writer.println("```properties");
                    writer.println("name=connector1");
                    writer.println("tasks.max=1");
                    writer.printf("connector.class=%s", clazz.getName());
                    writer.println();
                    writer.println();
                    writer.println("# Set these required values");
                    List<Map.Entry<String, ConfigDef.ConfigKey>> requiredValues = this.required(configDef);
                    for (Map.Entry<String, ConfigDef.ConfigKey> kvp : requiredValues) {
                        writer.printf("%s=", kvp.getKey());
                        writer.println();
                    }
                    writer.println("```");
                    writer.println();
                    writer.println(MarkdownFormatter.toMarkdown((ConfigDef)configDef));
                }
                for (Class<? extends Connector> clazz : this.transformClasses) {
                    if (Modifier.isAbstract(clazz.getModifiers())) {
                        log.trace("Skipping {} because it's abstract.", (Object)clazz.getName());
                        continue;
                    }
                    writer.printf("## %s", clazz.getSimpleName());
                    writer.println();
                    descriptionAttribute = clazz.getAnnotation(Description.class);
                    if (null != descriptionAttribute && !Strings.isNullOrEmpty((String)descriptionAttribute.value())) {
                        writer.println();
                        writer.append(descriptionAttribute.value());
                        writer.println();
                    }
                    writer.println();
                    Transformation transformation = (Transformation)clazz.newInstance();
                    configDef = transformation.config();
                    writer.println("```properties");
                    String transformName = clazz.getSimpleName().toLowerCase();
                    writer.printf("transforms=%s", transformName);
                    writer.println();
                    writer.printf("transforms.%s.type=%s", transformName, clazz.getName());
                    writer.println();
                    writer.println();
                    writer.println("# Set these required values");
                    List<Map.Entry<String, ConfigDef.ConfigKey>> requiredValues = this.required(configDef);
                    for (Map.Entry<String, ConfigDef.ConfigKey> kvp : requiredValues) {
                        writer.printf("transforms.%s.%s=", transformName, kvp.getKey());
                        writer.println();
                    }
                    writer.println("```");
                    writer.println();
                    writer.println(MarkdownFormatter.toMarkdown((ConfigDef)configDef));
                }
                List<Schema> schemas = this.schemas();
                if (!schemas.isEmpty()) {
                    writer.println();
                    writer.println("# Schemas");
                    writer.println();
                    for (Schema schema : this.schemas()) {
                        writer.println(MarkdownFormatter.toMarkdown((Schema)schema));
                    }
                }
            }
            log.info("{}", (Object)stringWriter);
        }
    }
}

