/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.config.Description;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationDanger;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationImportant;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationTip;
import com.github.jcustenborder.kafka.connect.utils.config.DocumentationWarning;
import com.github.jcustenborder.kafka.connect.utils.config.Title;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateInput {
    private static final Logger log = LoggerFactory.getLogger(TemplateInput.class);
    private String title;
    private String description;
    private String className;
    private String warning;
    private String tip;
    private String important;
    private String danger;
    private List<ConfigEntry> requiredConfigs;
    private List<ConfigEntry> configs;
    private Map<String, Integer> columnLengths;

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassName() {
        return this.className;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getTip() {
        return this.tip;
    }

    public String getImportant() {
        return this.important;
    }

    public String getDanger() {
        return this.danger;
    }

    public List<ConfigEntry> getRequiredConfigs() {
        return this.requiredConfigs;
    }

    public List<ConfigEntry> getConfigs() {
        return this.configs;
    }

    public Map<String, Integer> getColumnLengths() {
        return this.columnLengths;
    }

    private static String title(Class<?> aClass) {
        Title annotation = aClass.getAnnotation(Title.class);
        String result = null != annotation ? annotation.value() : aClass.getSimpleName();
        return result;
    }

    private static String description(Class<?> aClass) {
        Description annotation = aClass.getAnnotation(Description.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String danger(Class<?> aClass) {
        DocumentationDanger annotation = aClass.getAnnotation(DocumentationDanger.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String important(Class<?> aClass) {
        DocumentationImportant annotation = aClass.getAnnotation(DocumentationImportant.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String tip(Class<?> aClass) {
        DocumentationTip annotation = aClass.getAnnotation(DocumentationTip.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static String warning(Class<?> aClass) {
        DocumentationWarning annotation = aClass.getAnnotation(DocumentationWarning.class);
        String result = null != annotation ? annotation.value() : null;
        return result;
    }

    private static void populateTemplate(Class<?> aClass, TemplateInput result, ConfigDef config) {
        result.className = aClass.getName();
        result.title = TemplateInput.title(aClass);
        result.description = TemplateInput.description(aClass);
        result.tip = TemplateInput.tip(aClass);
        result.warning = TemplateInput.warning(aClass);
        result.important = TemplateInput.important(aClass);
        result.danger = TemplateInput.danger(aClass);
        ArrayList keys = new ArrayList(config.configKeys().values());
        keys.sort((k1, k2) -> {
            if (!k1.hasDefault() && k2.hasDefault()) {
                return -1;
            }
            if (!k2.hasDefault() && k1.hasDefault()) {
                return 1;
            }
            int cmp = k1.importance.compareTo((Enum)k2.importance);
            if (cmp == 0) {
                return k1.name.compareTo(k2.name);
            }
            return cmp;
        });
        result.requiredConfigs = new ArrayList<ConfigEntry>();
        ArrayList<ConfigEntry> configs = new ArrayList<ConfigEntry>();
        for (ConfigDef.ConfigKey key : keys) {
            ConfigEntry entry = new ConfigEntry();
            entry.name = key.name;
            entry.importance = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.importance.toString());
            entry.doc = key.documentation;
            entry.type = key.type.toString().toLowerCase();
            if (key.hasDefault()) {
                entry.defaultValue = key.defaultValue.toString();
            }
            if (null != key.validator) {
                entry.validator = key.validator.toString();
            }
            configs.add(entry);
            if (key.hasDefault()) continue;
            result.requiredConfigs.add(entry);
        }
        result.configs = configs;
        LinkedHashMap<String, Integer> lengths = new LinkedHashMap<String, Integer>();
        TemplateInput.checkLength(lengths, "name", "Name");
        TemplateInput.checkLength(lengths, "type", "Type");
        TemplateInput.checkLength(lengths, "importance", "Importance");
        TemplateInput.checkLength(lengths, "doc", "Documentation");
        TemplateInput.checkLength(lengths, "defaultValue", "Default Value");
        TemplateInput.checkLength(lengths, "validator", "validator");
        for (ConfigEntry entry : configs) {
            TemplateInput.checkLength(lengths, "name", entry.name);
            TemplateInput.checkLength(lengths, "type", String.format(":ref:`configuration-%s`", entry.type));
            TemplateInput.checkLength(lengths, "importance", entry.importance);
            TemplateInput.checkLength(lengths, "doc", entry.doc);
            TemplateInput.checkLength(lengths, "defaultValue", entry.defaultValue);
            TemplateInput.checkLength(lengths, "validator", entry.validator);
        }
        result.columnLengths = ImmutableMap.copyOf(lengths);
    }

    static TemplateInput fromTransformation(Class<? extends Transformation> transform) throws IllegalAccessException, InstantiationException {
        TemplateInput result = new TemplateInput();
        Transformation sourceConnector = transform.newInstance();
        ConfigDef config = sourceConnector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        TemplateInput.populateTemplate(transform, result, config);
        return result;
    }

    static TemplateInput fromConnector(Class<? extends Connector> connectorClass) throws IllegalAccessException, InstantiationException {
        TemplateInput result = new TemplateInput();
        Connector connector = connectorClass.newInstance();
        ConfigDef config = connector.config();
        Assertions.assertNotNull((Object)config, (String)"config() cannot return a null.");
        TemplateInput.populateTemplate(connectorClass, result, config);
        return result;
    }

    static void checkLength(Map<String, Integer> columnLengths, String name, Object value) {
        int current;
        int length = (value != null ? value.toString().length() : 0) + 2;
        if (length > (current = columnLengths.getOrDefault(name, 0).intValue())) {
            columnLengths.put(name, length);
        }
    }

    public static class ConfigEntry {
        private String name;
        private String importance;
        private String doc;
        private String defaultValue = "";
        private String validator = "";
        private String type;

        public String name() {
            return this.name;
        }

        public String importance() {
            return this.importance;
        }

        public String doc() {
            return this.doc;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public String validator() {
            return this.validator;
        }

        public String type() {
            return this.type;
        }
    }
}

