/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.AssertSchema;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertStruct {
    private static final Logger log = LoggerFactory.getLogger(AssertStruct.class);

    static <T> T castAndVerify(Class<T> cls, Struct struct, Field field, boolean expected) {
        Object value = struct.get(field.name());
        String prefix = String.format("%s('%s') ", expected ? "expected" : "actual", field.name());
        if (!field.schema().isOptional()) {
            Assertions.assertNotNull((Object)value, (String)(prefix + "has a require schema. Should not be null."));
        }
        if (null == value) {
            return null;
        }
        Assertions.assertTrue((boolean)cls.isInstance(value), (String)String.format(prefix + "should be a %s", cls.getSimpleName()));
        return cls.cast(value);
    }

    public static void assertStruct(Struct expected, Struct actual, String message) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        AssertSchema.assertSchema(expected.schema(), actual.schema(), "schema does not match.");
        block6: for (Field expectedField : expected.schema().fields()) {
            log.trace("assertStruct() - testing field '{}'", (Object)expectedField.name());
            Object expectedValue = expected.get(expectedField.name());
            Object actualValue = actual.get(expectedField.name());
            if ("org.apache.kafka.connect.data.Decimal".equals(expectedField.schema().name())) {
                BigDecimal expectedDecimal = AssertStruct.castAndVerify(BigDecimal.class, expected, expectedField, true);
                BigDecimal actualDecimal = AssertStruct.castAndVerify(BigDecimal.class, actual, expectedField, false);
                Assertions.assertEquals((Object)expectedDecimal, (Object)actualDecimal, (String)(prefix + expectedField.name() + " does not match."));
                continue;
            }
            if ("org.apache.kafka.connect.data.Timestamp".equals(expectedField.schema().name()) || "org.apache.kafka.connect.data.Date".equals(expectedField.schema().name()) || "org.apache.kafka.connect.data.Time".equals(expectedField.schema().name())) {
                Date expectedDate = AssertStruct.castAndVerify(Date.class, expected, expectedField, true);
                Date actualDate = AssertStruct.castAndVerify(Date.class, actual, expectedField, false);
                Assertions.assertEquals((Object)expectedDate, (Object)actualDate, (String)(prefix + expectedField.name() + " does not match."));
                continue;
            }
            switch (expectedField.schema().type()) {
                case ARRAY: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof List ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof List ? 1 : 0) != 0);
                    List expectedArray = (List)expectedValue;
                    List actualArray = (List)actualValue;
                    Assertions.assertEquals((Object)expectedArray, (Object)actualArray, (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
                case MAP: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof Map ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof Map ? 1 : 0) != 0);
                    Map expectedMap = (Map)expectedValue;
                    Map actualMap = (Map)actualValue;
                    Assertions.assertEquals((Object)expectedMap, (Object)actualMap, (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
                case STRUCT: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof Struct ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof Struct ? 1 : 0) != 0);
                    Struct expectedStruct = (Struct)expectedValue;
                    Struct actualStruct = (Struct)actualValue;
                    AssertStruct.assertStruct(expectedStruct, actualStruct, prefix + expectedField.name() + " does not match.");
                    continue block6;
                }
                case BYTES: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof byte[] ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof byte[] ? 1 : 0) != 0);
                    byte[] expectedByteArray = (byte[])expectedValue;
                    byte[] actualByteArray = (byte[])actualValue;
                    Assertions.assertEquals((Object)(null == expectedByteArray ? "" : BaseEncoding.base32Hex().encode(expectedByteArray).toString()), (Object)(null == actualByteArray ? "" : BaseEncoding.base32Hex().encode(actualByteArray).toString()), (String)(prefix + expectedField.name() + " does not match."));
                    continue block6;
                }
            }
            Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)(prefix + expectedField.name() + " does not match."));
        }
    }

    public static void assertStruct(Struct expected, Struct actual) {
        AssertStruct.assertStruct(expected, actual, null);
    }
}

