/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.github.jcustenborder.kafka.connect.utils.AssertSchema;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertStruct {
    private static final Logger log = LoggerFactory.getLogger(AssertStruct.class);

    public static void assertStruct(Struct expected, Struct actual, String message) {
        String prefix;
        String string = prefix = Strings.isNullOrEmpty((String)message) ? "" : message + ": ";
        if (null == expected) {
            Assertions.assertNull((Object)actual, (String)(prefix + "actual should be null."));
            return;
        }
        AssertSchema.assertSchema(expected.schema(), actual.schema(), "schema does not match.");
        block6: for (Field field : expected.schema().fields()) {
            log.trace("assertStruct() - testing field '{}'", (Object)field.name());
            Object expectedValue = expected.get(field.name());
            Object actualValue = actual.get(field.name());
            switch (field.schema().type()) {
                case ARRAY: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof List ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof List ? 1 : 0) != 0);
                    List expectedArray = (List)expectedValue;
                    List actualArray = (List)actualValue;
                    Assertions.assertEquals((Object)expectedArray, (Object)actualArray, (String)(prefix + field.name() + " does not match."));
                    continue block6;
                }
                case MAP: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof Map ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof Map ? 1 : 0) != 0);
                    Map expectedMap = (Map)expectedValue;
                    Map actualMap = (Map)actualValue;
                    Assertions.assertEquals((Object)expectedMap, (Object)actualMap, (String)(prefix + field.name() + " does not match."));
                    continue block6;
                }
                case STRUCT: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof Struct ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof Struct ? 1 : 0) != 0);
                    Struct expectedStruct = (Struct)expectedValue;
                    Struct actualStruct = (Struct)actualValue;
                    AssertStruct.assertStruct(expectedStruct, actualStruct, prefix + field.name() + " does not match.");
                    continue block6;
                }
                case BYTES: {
                    Assertions.assertTrue((null == expectedValue || expectedValue instanceof byte[] ? 1 : 0) != 0);
                    Assertions.assertTrue((null == actualValue || actualValue instanceof byte[] ? 1 : 0) != 0);
                    byte[] expectedByteArray = (byte[])expectedValue;
                    byte[] actualByteArray = (byte[])actualValue;
                    Assertions.assertEquals((Object)(null == expectedByteArray ? "" : BaseEncoding.base32Hex().encode(expectedByteArray).toString()), (Object)(null == actualByteArray ? "" : BaseEncoding.base32Hex().encode(actualByteArray).toString()), (String)(prefix + field.name() + " does not match."));
                    continue block6;
                }
            }
            Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)(prefix + field.name() + " does not match."));
        }
    }

    public static void assertStruct(Struct expected, Struct actual) {
        AssertStruct.assertStruct(expected, actual, null);
    }
}

