/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.osx;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import com.github.javakeyring.internal.osx.NativeLibraryManager;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;

public class OsxKeychainBackend
implements KeyringBackend {
    private final NativeLibraryManager nativeLibraries = new NativeLibraryManager();

    @Override
    public String getPassword(String service, String account) throws PasswordAccessException {
        Charset charset = Charset.forName("UTF-8");
        byte[] serviceBytes = service.getBytes(charset);
        byte[] accountBytes = account.getBytes(charset);
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        int status = this.nativeLibraries.getSecurity().SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, dataLength, data, null);
        if (status != 0) {
            throw new PasswordAccessException(this.convertErrorCodeToMessage(status));
        }
        byte[] passwordBytes = data[0].getByteArray(0L, dataLength[0]);
        this.nativeLibraries.getSecurity().SecKeychainItemFreeContent(null, data[0]);
        return new String(passwordBytes, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        Charset charset = Charset.forName("UTF-8");
        byte[] serviceBytes = service.getBytes(charset);
        byte[] accountBytes = account.getBytes(charset);
        byte[] passwordBytes = password.getBytes(charset);
        Pointer[] itemRef = new Pointer[1];
        int status = this.nativeLibraries.getSecurity().SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, null, null, itemRef);
        if (status != 0 && status != -25300) {
            throw new PasswordAccessException(this.convertErrorCodeToMessage(status));
        }
        if (itemRef[0] != null) {
            try {
                status = this.nativeLibraries.getSecurity().SecKeychainItemModifyContent(itemRef[0], null, passwordBytes.length, passwordBytes);
            }
            finally {
                this.nativeLibraries.getCoreFoundation().CFRelease(itemRef[0]);
            }
        } else {
            status = this.nativeLibraries.getSecurity().SecKeychainAddGenericPassword(Pointer.NULL, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, passwordBytes.length, passwordBytes, null);
        }
        if (status != 0) {
            throw new PasswordAccessException(this.convertErrorCodeToMessage(status));
        }
    }

    @Override
    public void deletePassword(String service, String account) throws PasswordAccessException {
        Charset charset = Charset.forName("UTF-8");
        byte[] serviceBytes = service.getBytes(charset);
        byte[] accountBytes = account.getBytes(charset);
        Pointer[] itemRef = new Pointer[1];
        int status = this.nativeLibraries.getSecurity().SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, accountBytes.length, accountBytes, null, null, itemRef);
        if (status != 0 && status != -25300) {
            throw new PasswordAccessException(this.convertErrorCodeToMessage(status));
        }
        if (itemRef[0] != null) {
            status = this.nativeLibraries.getSecurity().SecKeychainItemDelete(itemRef[0]);
        }
        if (status != 0) {
            throw new PasswordAccessException(this.convertErrorCodeToMessage(status));
        }
    }

    private String convertErrorCodeToMessage(int errorCode) {
        Pointer msgPtr = this.nativeLibraries.getSecurity().SecCopyErrorMessageString(errorCode, null);
        if (msgPtr == null) {
            return null;
        }
        int bufSize = (int)this.nativeLibraries.getCoreFoundation().CFStringGetLength(msgPtr);
        char[] buf = new char[bufSize];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.nativeLibraries.getCoreFoundation().CFStringGetCharacterAtIndex(msgPtr, i);
        }
        this.nativeLibraries.getCoreFoundation().CFRelease(msgPtr);
        return new String(buf);
    }
}

