/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.view.Window;
import android.view.WindowManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b\u00a8\u0006\u0019"}, d2={"Lando/toolkit/ActivityUtils;", "", "()V", "hideTitleBar", "", "activity", "Landroid/app/Activity;", "ifAddShortCut", "", "context", "Landroid/content/Context;", "appName", "", "isActivityLive", "setFullScreen", "setScreenHorizontal", "setScreenVertical", "startActivity", "intent", "Landroid/content/Intent;", "startActivityForResult", "requestCode", "", "toggleFullScreen", "isFull", "ando_toolkit_release"})
public final class ActivityUtils {
    @NotNull
    public static final ActivityUtils INSTANCE = new ActivityUtils();

    private ActivityUtils() {
    }

    public final boolean isActivityLive(@Nullable Activity activity) {
        return activity != null && !activity.isFinishing() && !activity.isDestroyed();
    }

    public final void toggleFullScreen(@NotNull Activity activity, boolean isFull) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.hideTitleBar(activity);
        Window window = activity.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        if (isFull) {
            params.flags |= 0x400;
            window.setAttributes(params);
            window.addFlags(512);
        } else {
            params.flags &= 0xFFFFFBFF;
            window.setAttributes(params);
            window.clearFlags(512);
        }
    }

    public final void setFullScreen(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.toggleFullScreen(activity, true);
    }

    public final void hideTitleBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activity instanceof AppCompatActivity) {
            ((AppCompatActivity)activity).supportRequestWindowFeature(1);
        } else {
            activity.requestWindowFeature(1);
        }
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public final void setScreenVertical(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.setRequestedOrientation(1);
    }

    public final void setScreenHorizontal(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.setRequestedOrientation(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ifAddShortCut(@NotNull Context context, @NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        boolean isInstallShortCut = false;
        ContentResolver cr = context.getContentResolver();
        String authority = "com.android.launcher2.settings";
        Cursor cursor = null;
        try {
            Uri uri = Uri.parse((String)("content://" + authority + "/favorites?notify=true"));
            String[] stringArray = new String[]{"title", "iconResource"};
            String[] stringArray2 = stringArray;
            stringArray = new String[]{appName};
            cursor = cr.query(uri, stringArray2, "title=?", stringArray, null);
            if (cursor != null && cursor.getCount() > 0) {
                isInstallShortCut = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Cursor cursor2 = cursor;
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        return isInstallShortCut;
    }

    public final void startActivity(@NotNull Object context, @NotNull Intent intent) {
        FragmentActivity activity;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (context instanceof Activity) {
            if (this.isActivityLive((Activity)context)) {
                ((Activity)context).startActivity(intent);
            }
        } else if (context instanceof Fragment && this.isActivityLive((Activity)(activity = ((Fragment)context).getActivity()))) {
            ((Fragment)context).startActivity(intent);
        }
    }

    public final void startActivityForResult(@NotNull Object context, @NotNull Intent intent, int requestCode) {
        FragmentActivity activity;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (context instanceof Activity) {
            if (this.isActivityLive((Activity)context)) {
                ((Activity)context).startActivityForResult(intent, requestCode);
            }
        } else if (context instanceof Fragment && this.isActivityLive((Activity)(activity = ((Fragment)context).getActivity()))) {
            ((Fragment)context).startActivityForResult(intent, requestCode);
        }
    }
}

