/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.ext;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u000f\u001a\u00020\u0001\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00052\b\b\u0001\u0010\u000f\u001a\u00020\u0001\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00072\b\b\u0001\u0010\u000f\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0012*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0015\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0015\u001a\u00020\u0012*\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0012\u0010\u0015\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0007\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0004\"\u0015\u0010\f\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\"\u0017\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0018"}, d2={"screenDensityDpi", "", "Landroid/content/Context;", "getScreenDensityDpi", "(Landroid/content/Context;)I", "Landroid/view/View;", "(Landroid/view/View;)I", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)I", "screenHeight", "getScreenHeight", "(Landroidx/fragment/app/Fragment;)Ljava/lang/Integer;", "screenWidth", "getScreenWidth", "dimen2px", "resource", "dp2px", "value", "", "px2dp", "px", "px2sp", "realDpi", "sp2px", "ando_toolkit_release"})
public final class DimensionsExtKt {
    public static final int getScreenDensityDpi(@NotNull Context $this$screenDensityDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$screenDensityDpi, (String)"$this$screenDensityDpi");
        Resources resources = $this$screenDensityDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().densityDpi;
    }

    public static final int getScreenWidth(@NotNull Context $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"$this$screenWidth");
        Resources resources = $this$screenWidth.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight(@NotNull Context $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"$this$screenHeight");
        Resources resources = $this$screenHeight.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().heightPixels;
    }

    public static final int dp2px(@NotNull Context $this$dp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        float f = value;
        Resources resources = $this$dp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().density);
    }

    public static final int dp2px(@NotNull Context $this$dp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        Resources resources = $this$dp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().density);
    }

    public static final int sp2px(@NotNull Context $this$sp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        float f = value;
        Resources resources = $this$sp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(f * resources.getDisplayMetrics().scaledDensity);
    }

    public static final int sp2px(@NotNull Context $this$sp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        Resources resources = $this$sp2px.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(value * resources.getDisplayMetrics().scaledDensity);
    }

    public static final float px2dp(@NotNull Context $this$px2dp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"$this$px2dp");
        float f = px;
        Resources resources = $this$px2dp.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().density;
    }

    public static final float px2sp(@NotNull Context $this$px2sp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2sp, (String)"$this$px2sp");
        float f = px;
        Resources resources = $this$px2sp.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return f / resources.getDisplayMetrics().scaledDensity;
    }

    public static final int dimen2px(@NotNull Context $this$dimen2px, @DimenRes int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$dimen2px, (String)"$this$dimen2px");
        return $this$dimen2px.getResources().getDimensionPixelSize(resource);
    }

    public static final int realDpi(@NotNull Context $this$realDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$realDpi, (String)"$this$realDpi");
        Resources resources = $this$realDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metric = resources.getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }

    public static final int getScreenDensityDpi(@NotNull Fragment $this$screenDensityDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$screenDensityDpi, (String)"$this$screenDensityDpi");
        Resources resources = $this$screenDensityDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().densityDpi;
    }

    @Nullable
    public static final Integer getScreenWidth(@NotNull Fragment $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"$this$screenWidth");
        FragmentActivity fragmentActivity = $this$screenWidth.getActivity();
        return fragmentActivity != null ? Integer.valueOf(DimensionsExtKt.getScreenWidth((Context)fragmentActivity)) : null;
    }

    @Nullable
    public static final Integer getScreenHeight(@NotNull Fragment $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"$this$screenHeight");
        FragmentActivity fragmentActivity = $this$screenHeight.getActivity();
        return fragmentActivity != null ? Integer.valueOf(DimensionsExtKt.getScreenHeight((Context)fragmentActivity)) : null;
    }

    public static final int dp2px(@NotNull Fragment $this$dp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        FragmentActivity fragmentActivity = $this$dp2px.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.dp2px((Context)fragmentActivity, value) : 0;
    }

    public static final int dp2px(@NotNull Fragment $this$dp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        FragmentActivity fragmentActivity = $this$dp2px.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.dp2px((Context)fragmentActivity, value) : 0;
    }

    public static final int sp2px(@NotNull Fragment $this$sp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        FragmentActivity fragmentActivity = $this$sp2px.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.sp2px((Context)fragmentActivity, value) : 0;
    }

    public static final int sp2px(@NotNull Fragment $this$sp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        FragmentActivity fragmentActivity = $this$sp2px.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.sp2px((Context)fragmentActivity, value) : 0;
    }

    public static final float px2dp(@NotNull Fragment $this$px2dp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"$this$px2dp");
        FragmentActivity fragmentActivity = $this$px2dp.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.px2dp((Context)fragmentActivity, px) : 0.0f;
    }

    public static final float px2sp(@NotNull Fragment $this$px2sp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2sp, (String)"$this$px2sp");
        FragmentActivity fragmentActivity = $this$px2sp.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.px2sp((Context)fragmentActivity, px) : 0.0f;
    }

    public static final int dimen2px(@NotNull Fragment $this$dimen2px, @DimenRes int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$dimen2px, (String)"$this$dimen2px");
        FragmentActivity fragmentActivity = $this$dimen2px.getActivity();
        return fragmentActivity != null ? DimensionsExtKt.dimen2px((Context)fragmentActivity, resource) : 0;
    }

    public static final int realDpi(@NotNull Fragment $this$realDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$realDpi, (String)"$this$realDpi");
        Resources resources = $this$realDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metric = resources.getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }

    public static final int getScreenDensityDpi(@NotNull View $this$screenDensityDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$screenDensityDpi, (String)"$this$screenDensityDpi");
        Resources resources = $this$screenDensityDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return resources.getDisplayMetrics().densityDpi;
    }

    public static final int getScreenWidth(@NotNull View $this$screenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$screenWidth, (String)"$this$screenWidth");
        Context context = $this$screenWidth.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.getScreenWidth(context);
    }

    public static final int getScreenHeight(@NotNull View $this$screenHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$screenHeight, (String)"$this$screenHeight");
        Context context = $this$screenHeight.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.getScreenHeight(context);
    }

    public static final int dp2px(@NotNull View $this$dp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        Context context = $this$dp2px.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.dp2px(context, value);
    }

    public static final int dp2px(@NotNull View $this$dp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$dp2px, (String)"$this$dp2px");
        Context context = $this$dp2px.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.dp2px(context, value);
    }

    public static final int sp2px(@NotNull View $this$sp2px, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        Context context = $this$sp2px.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.sp2px(context, value);
    }

    public static final int sp2px(@NotNull View $this$sp2px, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$sp2px, (String)"$this$sp2px");
        Context context = $this$sp2px.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.sp2px(context, value);
    }

    public static final float px2dp(@NotNull View $this$px2dp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2dp, (String)"$this$px2dp");
        Context context = $this$px2dp.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.px2dp(context, px);
    }

    public static final float px2sp(@NotNull View $this$px2sp, int px) {
        Intrinsics.checkNotNullParameter((Object)$this$px2sp, (String)"$this$px2sp");
        Context context = $this$px2sp.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.px2sp(context, px);
    }

    public static final int dimen2px(@NotNull View $this$dimen2px, @DimenRes int resource) {
        Intrinsics.checkNotNullParameter((Object)$this$dimen2px, (String)"$this$dimen2px");
        Context context = $this$dimen2px.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        return DimensionsExtKt.dimen2px(context, resource);
    }

    public static final int realDpi(@NotNull View $this$realDpi) {
        Intrinsics.checkNotNullParameter((Object)$this$realDpi, (String)"$this$realDpi");
        Resources resources = $this$realDpi.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metric = resources.getDisplayMetrics();
        float xdpi = metric.xdpi;
        float ydpi = metric.ydpi;
        return (int)((xdpi + ydpi) / 2.0f + 0.5f);
    }
}

