/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.os.PowerManager;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0003J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\nR\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lando/toolkit/ScreenLockUtils;", "", "()V", "TAG", "", "mIsUnlockArray", "Ljava/util/HashMap;", "Landroid/app/Activity;", "", "mWakeLockArray", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "cancelKeepScreen", "", "activity", "cancelLockScreen", "keepScreenOn", "ando_toolkit_release"})
public final class ScreenLockUtils {
    private static final String TAG = "ScreenLockUtil";
    private static final HashMap<Activity, PowerManager.WakeLock> mWakeLockArray;
    private static final HashMap<Activity, Boolean> mIsUnlockArray;
    @NotNull
    public static final ScreenLockUtils INSTANCE;

    public final void keepScreenOn(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        PowerManager.WakeLock wakeLock = mWakeLockArray.get(activity);
        if (wakeLock == null) {
            Object object = activity.getSystemService("power");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
            }
            PowerManager powerManager = (PowerManager)object;
            wakeLock = powerManager.newWakeLock(0x1000001A, activity.getClass().getName());
        }
        PowerManager.WakeLock wakeLock2 = wakeLock;
        if (wakeLock2 != null) {
            PowerManager.WakeLock wakeLock3 = wakeLock2;
            boolean bl = false;
            boolean bl2 = false;
            PowerManager.WakeLock $this$apply = wakeLock3;
            boolean bl3 = false;
            if (!$this$apply.isHeld()) {
                $this$apply.acquire(600000L);
            }
            ((Map)mWakeLockArray).put(activity, $this$apply);
        }
        this.cancelLockScreen(activity);
        Log.i((String)TAG, (String)"\u5f00\u542f\u5c4f\u5e55\u5e38\u4eae");
    }

    public final void cancelKeepScreen(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        PowerManager.WakeLock wakeLock = mWakeLockArray.get(activity);
        if (wakeLock != null && wakeLock.isHeld()) {
            wakeLock.release();
        }
        Log.i((String)TAG, (String)"\u53d6\u6d88\u5c4f\u5e55\u5e38\u4eae");
    }

    @SuppressLint(value={"MissingPermission"})
    private final void cancelLockScreen(Activity activity) {
        Boolean isUnlock = mIsUnlockArray.get(activity);
        if (isUnlock != null && isUnlock.booleanValue()) {
            return;
        }
        Object object = activity.getSystemService("keyguard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.KeyguardManager");
        }
        KeyguardManager keyguardManager = (KeyguardManager)object;
        KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock(activity.getClass().getName());
        keyguardLock.disableKeyguard();
        ((Map)mIsUnlockArray).put(activity, true);
    }

    private ScreenLockUtils() {
    }

    static {
        ScreenLockUtils screenLockUtils;
        INSTANCE = screenLockUtils = new ScreenLockUtils();
        mWakeLockArray = new HashMap();
        mIsUnlockArray = new HashMap();
    }
}

