/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.ext.DeviceUtils;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u001e\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0006\u0010\u001f\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lando/toolkit/NotchUtils;", "", "()V", "NOTCH_HUA_WEI", "", "NOTCH_OPPO", "NOTCH_VIVO", "NOTCH_XIAO_MI", "SYSTEM_PROPERTIES", "dp2px", "", "context", "Landroid/content/Context;", "dpValue", "getDisplayCutout", "Landroid/view/DisplayCutout;", "activity", "Landroid/app/Activity;", "view", "Landroid/view/View;", "getHuaWeiNotchSize", "", "getNotchHeight", "getXiaoMiNotchHeight", "hasNotchAtAndroidP", "", "hasNotchAtHuaWei", "hasNotchAtOPPO", "hasNotchAtVIVO", "hasNotchAtXiaoMi", "hasNotchScreen", "isNotchOfficialSupport", "ando_toolkit_release"})
public final class NotchUtils {
    private static final String SYSTEM_PROPERTIES = "android.os.SystemProperties";
    private static final String NOTCH_XIAO_MI = "ro.miui.notch";
    private static final String NOTCH_HUA_WEI = "com.huawei.android.util.HwNotchSizeUtil";
    private static final String NOTCH_VIVO = "android.util.FtFeature";
    private static final String NOTCH_OPPO = "com.oppo.feature.screen.heteromorphism";
    @NotNull
    public static final NotchUtils INSTANCE;

    public final boolean isNotchOfficialSupport() {
        return Build.VERSION.SDK_INT >= 28;
    }

    public final boolean hasNotchScreen(@Nullable Activity activity) {
        return activity != null && (this.hasNotchAtXiaoMi((Context)activity) || this.hasNotchAtHuaWei((Context)activity) || this.hasNotchAtOPPO((Context)activity) || this.hasNotchAtVIVO((Context)activity) || this.hasNotchAtAndroidP(activity));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasNotchScreen(@Nullable View view) {
        if (view == null) return false;
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
        if (this.hasNotchAtXiaoMi(context)) return true;
        Context context2 = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"view.context");
        if (this.hasNotchAtHuaWei(context2)) return true;
        Context context3 = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"view.context");
        if (this.hasNotchAtOPPO(context3)) return true;
        Context context4 = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"view.context");
        if (this.hasNotchAtVIVO(context4)) return true;
        if (!this.hasNotchAtAndroidP(view)) return false;
        return true;
    }

    private final boolean hasNotchAtAndroidP(View view) {
        return this.getDisplayCutout(view) != null;
    }

    private final boolean hasNotchAtAndroidP(Activity activity) {
        return this.getDisplayCutout(activity) != null;
    }

    private final DisplayCutout getDisplayCutout(Activity activity) {
        Window window;
        if (Build.VERSION.SDK_INT >= 28 && activity != null && (window = activity.getWindow()) != null) {
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            WindowInsets windowInsets = view.getRootWindowInsets();
            if (windowInsets != null) {
                return windowInsets.getDisplayCutout();
            }
        }
        return null;
    }

    private final DisplayCutout getDisplayCutout(View view) {
        WindowInsets windowInsets;
        if (Build.VERSION.SDK_INT >= 28 && view != null && (windowInsets = view.getRootWindowInsets()) != null) {
            return windowInsets.getDisplayCutout();
        }
        return null;
    }

    private final boolean hasNotchAtXiaoMi(Context context) {
        int result = 0;
        if (Intrinsics.areEqual((Object)"Xiaomi", (Object)Build.MANUFACTURER)) {
            try {
                ClassLoader classLoader = context.getClassLoader();
                Class<?> aClass = classLoader.loadClass(SYSTEM_PROPERTIES);
                Method method = aClass.getMethod("getInt", String.class, Integer.TYPE);
                Object object = method.invoke(aClass, NOTCH_XIAO_MI, 0);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                result = (Integer)object;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result == 1;
    }

    private final boolean hasNotchAtHuaWei(Context context) {
        boolean result = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> aClass = classLoader.loadClass(NOTCH_HUA_WEI);
            Method get = aClass.getMethod("hasNotchInScreen", new Class[0]);
            Object object = get.invoke(aClass, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            result = (Boolean)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private final boolean hasNotchAtVIVO(Context context) {
        boolean result = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> aClass = classLoader.loadClass(NOTCH_VIVO);
            Method method = aClass.getMethod("isFeatureSupport", Integer.TYPE);
            Object object = method.invoke(aClass, 32);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            result = (Boolean)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private final boolean hasNotchAtOPPO(Context context) {
        boolean bl;
        try {
            bl = context.getPackageManager().hasSystemFeature(NOTCH_OPPO);
        }
        catch (Exception ignored) {
            bl = false;
        }
        return bl;
    }

    public final int getNotchHeight(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int notchHeight = 0;
        int statusBarHeight = DeviceUtils.INSTANCE.getStatusBarHeight();
        DisplayCutout displayCutout = this.getDisplayCutout(activity);
        if (Build.VERSION.SDK_INT >= 28 && displayCutout != null) {
            Resources resources = activity.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"activity.resources");
            notchHeight = resources.getConfiguration().orientation == 1 ? displayCutout.getSafeInsetTop() : (displayCutout.getSafeInsetLeft() == 0 ? displayCutout.getSafeInsetRight() : displayCutout.getSafeInsetLeft());
        } else {
            if (this.hasNotchAtXiaoMi((Context)activity)) {
                notchHeight = this.getXiaoMiNotchHeight((Context)activity);
            }
            if (this.hasNotchAtHuaWei((Context)activity)) {
                notchHeight = this.getHuaWeiNotchSize((Context)activity)[1];
            }
            if (this.hasNotchAtVIVO((Context)activity) && (notchHeight = this.dp2px((Context)activity, 32)) < statusBarHeight) {
                notchHeight = statusBarHeight;
            }
            if (this.hasNotchAtOPPO((Context)activity) && (notchHeight = 80) < statusBarHeight) {
                notchHeight = statusBarHeight;
            }
        }
        return notchHeight;
    }

    private final int getXiaoMiNotchHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        return resourceId > 0 ? context.getResources().getDimensionPixelSize(resourceId) : 0;
    }

    private final int[] getHuaWeiNotchSize(Context context) {
        int[] nArray;
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> aClass = cl.loadClass(NOTCH_HUA_WEI);
            Method get = aClass.getMethod("getNotchSize", new Class[0]);
            Object object = get.invoke(aClass, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.IntArray");
            }
            nArray = (int[])object;
        }
        catch (ClassNotFoundException ignored) {
            nArray = ret;
        }
        catch (NoSuchMethodException ignored) {
            nArray = ret;
        }
        catch (Exception ignored) {
            nArray = ret;
        }
        return nArray;
    }

    private final int dp2px(Context context, int dpValue) {
        float f = dpValue;
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private NotchUtils() {
    }

    static {
        NotchUtils notchUtils;
        INSTANCE = notchUtils = new NotchUtils();
    }
}

