/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.log.L;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.text.TextUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006J\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ \u0010\u0011\u001a\u00020\u000b\"\n\b\u0000\u0010\u0012*\u0004\u0018\u00010\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u000e2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lando/toolkit/ActivityCollector;", "", "()V", "TAG", "", "activityList", "Ljava/util/Stack;", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "mCurActivity", "add", "", "weakRefActivity", "finishAll", "", "getAll", "getCurActivity", "haveActivity", "T", "tClass", "Ljava/lang/Class;", "isBackground", "context", "Landroid/content/Context;", "remove", "setCurActivity", "activity", "size", "", "ando_toolkit_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class ActivityCollector {
    private static final String TAG = "123";
    private static Activity mCurActivity;
    private static final Stack<WeakReference<Activity>> activityList;
    @NotNull
    public static final ActivityCollector INSTANCE;

    public final int size() {
        return activityList.size();
    }

    public final boolean add(@Nullable WeakReference<Activity> weakRefActivity) {
        return activityList.add(weakRefActivity);
    }

    public final void remove(@Nullable WeakReference<Activity> weakRefActivity) {
        boolean result = activityList.remove(weakRefActivity);
        L.INSTANCE.i(TAG, "remove activity reference " + result);
    }

    public final void setCurActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        mCurActivity = activity;
    }

    @Nullable
    public final Activity getCurActivity() {
        return mCurActivity;
    }

    @NotNull
    public final Stack<WeakReference<Activity>> getAll() {
        return activityList;
    }

    public final void finishAll() {
        Collection collection = activityList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterator iterator = activityList.iterator();
            while (iterator.hasNext()) {
                WeakReference activityWeakReference;
                WeakReference weakReference = activityWeakReference = (WeakReference)iterator.next();
                Object activity = weakReference != null ? (Activity)weakReference.get() : null;
                if (activity == null || activity.isFinishing() || activity.isDestroyed()) continue;
                activity.finish();
            }
            activityList.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends Activity> boolean haveActivity(@NotNull Class<T> tClass) {
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        int n = 0;
        int n2 = activityList.size();
        while (n < n2) {
            void i;
            WeakReference weakReference = (WeakReference)activityList.get((int)i);
            if (weakReference == null || (weakReference = (Activity)weakReference.get()) == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)weakReference, (String)"activityList[i]?.get() ?: return false");
            WeakReference activity = weakReference;
            if (TextUtils.equals((CharSequence)activity.getClass().getName(), (CharSequence)tClass.getName())) {
                return !activity.isDestroyed() || !activity.isFinishing();
            }
            ++i;
        }
        return false;
    }

    public final boolean isBackground(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("activity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
        }
        ActivityManager activityManager = (ActivityManager)object;
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            boolean bl;
            if (!Intrinsics.areEqual((Object)appProcess.processName, (Object)context.getPackageName())) continue;
            L.INSTANCE.i(context.getPackageName(), "\u6b64 appimportace =" + appProcess.importance + ",context.getClass().getName()=" + context.getClass().getName());
            if (appProcess.importance != 100) {
                L.INSTANCE.i(context.getPackageName(), "\u5904\u4e8e\u540e\u53f0" + appProcess.processName);
                bl = true;
            } else {
                L.INSTANCE.i(context.getPackageName(), "\u5904\u4e8e\u524d\u53f0" + appProcess.processName);
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private ActivityCollector() {
    }

    static {
        ActivityCollector activityCollector;
        INSTANCE = activityCollector = new ActivityCollector();
        activityList = new Stack();
    }
}

