/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.AppUtils;
import ando.toolkit.R;
import ando.toolkit.ext.DimensionUtils;
import ando.toolkit.log.L;
import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u001b\u001a\u00020\u0004H\u0007J\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lando/toolkit/KeyboardUtils;", "", "()V", "TAG_ON_GLOBAL_LAYOUT_LISTENER", "", "millis", "", "sDecorViewDelta", "fixAndroidBug5497", "", "activity", "Landroid/app/Activity;", "window", "Landroid/view/Window;", "fixSoftInputLeaks", "getContentViewInvisibleHeight", "getDecorViewInvisibleHeight", "hideSoftInput", "view", "Landroid/view/View;", "hideSoftInputByToggle", "isSoftInputVisible", "", "registerSoftInputChangedListener", "listener", "Lando/toolkit/KeyboardUtils$OnSoftInputChangedListener;", "showSoftInput", "flags", "toggleSoftInput", "unregisterSoftInputChangedListener", "OnSoftInputChangedListener", "ando_toolkit_release"})
public final class KeyboardUtils {
    private static final int TAG_ON_GLOBAL_LAYOUT_LISTENER = -8;
    private static long millis;
    private static int sDecorViewDelta;
    @NotNull
    public static final KeyboardUtils INSTANCE;

    public final void showSoftInput() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.toggleSoftInput(2, 1);
    }

    public final void showSoftInput(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!this.isSoftInputVisible(activity)) {
            this.toggleSoftInput();
        }
    }

    @JvmOverloads
    public final void showSoftInput(@NotNull View view, int flags) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Object object = AppUtils.INSTANCE.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        imm.showSoftInput(view, flags, new ResultReceiver(new Handler(Looper.getMainLooper())){

            protected void onReceiveResult(int resultCode, @NotNull Bundle resultData) {
                Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
                if (resultCode == 1 || resultCode == 3) {
                    KeyboardUtils.INSTANCE.toggleSoftInput();
                }
            }
        });
        imm.toggleSoftInput(2, 1);
    }

    public static /* synthetic */ void showSoftInput$default(KeyboardUtils keyboardUtils, View view, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        keyboardUtils.showSoftInput(view, n);
    }

    @JvmOverloads
    public final void showSoftInput(@NotNull View view) {
        KeyboardUtils.showSoftInput$default(this, view, 0, 2, null);
    }

    public final void hideSoftInput(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.hideSoftInput(window);
    }

    public final void hideSoftInput(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        View view = window.getCurrentFocus();
        if (view == null) {
            View decorView = window.getDecorView();
            View focusView = decorView.findViewWithTag((Object)"keyboardTagView");
            if (focusView == null) {
                view = (View)new EditText(window.getContext());
                view.setTag((Object)"keyboardTagView");
                View view2 = decorView;
                if (view2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                ((ViewGroup)view2).addView(view, 0, 0);
            } else {
                view = focusView;
            }
            view.requestFocus();
        }
        this.hideSoftInput(view);
    }

    public final void hideSoftInput(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Object object = AppUtils.INSTANCE.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public final void hideSoftInputByToggle(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        long nowMillis = System.currentTimeMillis();
        long delta = nowMillis - millis;
        boolean bl = false;
        if (Math.abs(delta) > (long)500 && this.isSoftInputVisible(activity)) {
            this.toggleSoftInput();
        }
        millis = nowMillis;
    }

    public final void toggleSoftInput() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.toggleSoftInput(0, 0);
    }

    public final boolean isSoftInputVisible(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        return this.getDecorViewInvisibleHeight(window) > 0;
    }

    private final int getDecorViewInvisibleHeight(Window window) {
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        StringBuilder stringBuilder = new StringBuilder().append("getDecorViewInvisibleHeight: ");
        View view = decorView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"decorView");
        Log.d((String)"KeyboardUtils", (String)stringBuilder.append(view.getBottom() - outRect.bottom).toString());
        int n = decorView.getBottom() - outRect.bottom;
        boolean bl = false;
        int delta = Math.abs(n);
        if (delta <= DimensionUtils.INSTANCE.getNavBarHeight() + DimensionUtils.INSTANCE.getStatusBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public final void registerSoftInputChangedListener(@NotNull Activity activity, @NotNull OnSoftInputChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.registerSoftInputChangedListener(window, listener);
    }

    public final void registerSoftInputChangedListener(@NotNull Window window, @NotNull OnSoftInputChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        int flags = window.getAttributes().flags;
        if ((flags & 0x200) != 0) {
            window.clearFlags(512);
        }
        FrameLayout contentView = (FrameLayout)window.findViewById(R.id.content);
        int[] decorViewInvisibleHeightPre = new int[]{this.getDecorViewInvisibleHeight(window)};
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = new ViewTreeObserver.OnGlobalLayoutListener(window, decorViewInvisibleHeightPre, listener){
            final /* synthetic */ Window $window;
            final /* synthetic */ int[] $decorViewInvisibleHeightPre;
            final /* synthetic */ OnSoftInputChangedListener $listener;

            public final void onGlobalLayout() {
                int height = KeyboardUtils.access$getDecorViewInvisibleHeight(KeyboardUtils.INSTANCE, this.$window);
                if (this.$decorViewInvisibleHeightPre[0] != height) {
                    this.$listener.onSoftInputChanged(height);
                    this.$decorViewInvisibleHeightPre[0] = height;
                }
            }
            {
                this.$window = window;
                this.$decorViewInvisibleHeightPre = nArray;
                this.$listener = onSoftInputChangedListener;
            }
        };
        FrameLayout frameLayout = contentView;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"contentView");
        frameLayout.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
        contentView.setTag(-8, (Object)onGlobalLayoutListener2);
    }

    public final void unregisterSoftInputChangedListener(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        FrameLayout contentView = (FrameLayout)window.findViewById(R.id.content);
        Object tag = contentView.getTag(-8);
        if (tag instanceof ViewTreeObserver.OnGlobalLayoutListener && Build.VERSION.SDK_INT >= 16) {
            FrameLayout frameLayout = contentView;
            Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"contentView");
            frameLayout.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)tag);
        }
    }

    public final void fixAndroidBug5497(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.fixAndroidBug5497(window);
    }

    public final void fixAndroidBug5497(@NotNull Window window) {
        View contentViewChild;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        int softInputMode = window.getAttributes().softInputMode;
        window.setSoftInputMode(softInputMode & ~16);
        FrameLayout contentView = (FrameLayout)window.findViewById(R.id.content);
        View view = contentViewChild = contentView.getChildAt(0);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentViewChild");
        int paddingBottom = view.getPaddingBottom();
        int[] contentViewInvisibleHeightPre5497 = new int[]{this.getContentViewInvisibleHeight(window)};
        FrameLayout frameLayout = contentView;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"contentView");
        frameLayout.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(window, contentViewInvisibleHeightPre5497, contentViewChild, paddingBottom){
            final /* synthetic */ Window $window;
            final /* synthetic */ int[] $contentViewInvisibleHeightPre5497;
            final /* synthetic */ View $contentViewChild;
            final /* synthetic */ int $paddingBottom;

            public final void onGlobalLayout() {
                int height = KeyboardUtils.access$getContentViewInvisibleHeight(KeyboardUtils.INSTANCE, this.$window);
                if (this.$contentViewInvisibleHeightPre5497[0] != height) {
                    View view = this.$contentViewChild;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"contentViewChild");
                    int n = view.getPaddingLeft();
                    View view2 = this.$contentViewChild;
                    Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"contentViewChild");
                    int n2 = view2.getPaddingTop();
                    View view3 = this.$contentViewChild;
                    Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"contentViewChild");
                    this.$contentViewChild.setPadding(n, n2, view3.getPaddingRight(), this.$paddingBottom + KeyboardUtils.access$getDecorViewInvisibleHeight(KeyboardUtils.INSTANCE, this.$window));
                    this.$contentViewInvisibleHeightPre5497[0] = height;
                }
            }
            {
                this.$window = window;
                this.$contentViewInvisibleHeightPre5497 = nArray;
                this.$contentViewChild = view;
                this.$paddingBottom = n;
            }
        });
    }

    private final int getContentViewInvisibleHeight(Window window) {
        View view = window.findViewById(R.id.content);
        if (view == null) {
            return 0;
        }
        View contentView = view;
        Rect outRect = new Rect();
        contentView.getWindowVisibleDisplayFrame(outRect);
        L.INSTANCE.d("getContentViewInvisibleHeight: " + (contentView.getBottom() - outRect.bottom));
        int n = contentView.getBottom() - outRect.bottom;
        boolean bl = false;
        int delta = Math.abs(n);
        return delta <= DimensionUtils.INSTANCE.getStatusBarHeight() + DimensionUtils.INSTANCE.getNavBarHeight() ? 0 : delta;
    }

    public final void fixSoftInputLeaks(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        this.fixSoftInputLeaks(window);
    }

    public final void fixSoftInputLeaks(@NotNull Window window) {
        String[] leakViews;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Object object = AppUtils.INSTANCE.getContext().getSystemService("input_method");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        for (String leakView : leakViews = new String[]{"mLastSrvView", "mCurRootView", "mServedView", "mNextServedView"}) {
            try {
                View obj;
                Object object2;
                Field leakViewField;
                Field field = leakViewField = InputMethodManager.class.getDeclaredField(leakView);
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"leakViewField");
                if (!field.isAccessible()) {
                    leakViewField.setAccessible(true);
                }
                if (!((object2 = leakViewField.get(imm)) instanceof View)) {
                    object2 = null;
                }
                if ((View)object2 == null) {
                    continue;
                }
                View view = obj.getRootView();
                View view2 = window.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"window.decorView");
                if (view != view2.getRootView()) continue;
                leakViewField.set(imm, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private KeyboardUtils() {
    }

    static {
        KeyboardUtils keyboardUtils;
        INSTANCE = keyboardUtils = new KeyboardUtils();
    }

    public static final /* synthetic */ int access$getDecorViewInvisibleHeight(KeyboardUtils $this, Window window) {
        return $this.getDecorViewInvisibleHeight(window);
    }

    public static final /* synthetic */ int access$getContentViewInvisibleHeight(KeyboardUtils $this, Window window) {
        return $this.getContentViewInvisibleHeight(window);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lando/toolkit/KeyboardUtils$OnSoftInputChangedListener;", "", "onSoftInputChanged", "", "height", "", "ando_toolkit_release"})
    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

