/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.ext.ToastUtils;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 %2\u00020\u0001:\u0004%&'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u000eJ\u0010\u0010!\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u0010J\u0010\u0010\"\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010\u0012J\u0006\u0010#\u001a\u00020\tJ\u0006\u0010$\u001a\u00020\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lando/toolkit/BluetoothUtils;", "", "()V", "bondedDevices", "Ljava/util/ArrayList;", "Landroid/bluetooth/BluetoothDevice;", "getBondedDevices", "()Ljava/util/ArrayList;", "isOpen", "", "()Z", "mAdapter", "Landroid/bluetooth/BluetoothAdapter;", "mBondListener", "Lando/toolkit/BluetoothUtils$OnBondListener;", "mOpenListener", "Lando/toolkit/BluetoothUtils$OnOpenListener;", "mScanListener", "Lando/toolkit/BluetoothUtils$OnScanListener;", "createBond", "device", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "open", "printAllInform", "removeBond", "btDevice", "setOnBondListener", "listener", "setOnOpenListener", "setOnScanListener", "startScan", "stopScan", "Companion", "OnBondListener", "OnOpenListener", "OnScanListener", "ando_toolkit_release"})
@SuppressLint(value={"MissingPermission"})
public final class BluetoothUtils {
    private final BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private OnScanListener mScanListener;
    private OnBondListener mBondListener;
    private OnOpenListener mOpenListener;
    private static final BluetoothUtils instance;
    @NotNull
    public static final Companion Companion;

    public final void setOnScanListener(@Nullable OnScanListener listener) {
        this.mScanListener = listener;
    }

    public final void setOnBondListener(@Nullable OnBondListener listener) {
        this.mBondListener = listener;
    }

    public final void setOnOpenListener(@Nullable OnOpenListener listener) {
        this.mOpenListener = listener;
    }

    public final boolean isOpen() {
        if (this.mAdapter == null) {
            ToastUtils.INSTANCE.shortToast("\u6b64\u8bbe\u5907\u4e0d\u652f\u6301\u84dd\u7259\u4f20\u8f93\u529f\u80fd\uff01");
            return false;
        }
        return this.mAdapter.isEnabled();
    }

    public final void open(boolean open) {
        block1: {
            block0: {
                if (!open) break block0;
                BluetoothAdapter bluetoothAdapter = this.mAdapter;
                if (bluetoothAdapter == null) break block1;
                bluetoothAdapter.enable();
                break block1;
            }
            BluetoothAdapter bluetoothAdapter = this.mAdapter;
            if (bluetoothAdapter == null) break block1;
            bluetoothAdapter.disable();
        }
    }

    @NotNull
    public final ArrayList<BluetoothDevice> getBondedDevices() {
        ArrayList<BluetoothDevice> list;
        block0: {
            BluetoothAdapter bluetoothAdapter = this.mAdapter;
            Set devices = bluetoothAdapter != null ? bluetoothAdapter.getBondedDevices() : null;
            list = new ArrayList<BluetoothDevice>();
            Set set = devices;
            if (set == null) break block0;
            Set set2 = set;
            boolean bl = false;
            boolean bl2 = false;
            Set it = set2;
            boolean bl3 = false;
            list.addAll(it);
        }
        return list;
    }

    public final boolean startScan() {
        BluetoothAdapter bluetoothAdapter = this.mAdapter;
        return bluetoothAdapter != null ? bluetoothAdapter.startDiscovery() : false;
    }

    public final boolean stopScan() {
        BluetoothAdapter bluetoothAdapter = this.mAdapter;
        return bluetoothAdapter != null ? bluetoothAdapter.cancelDiscovery() : false;
    }

    public final boolean createBond(@NotNull BluetoothDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        if (device.getBondState() == 10) {
            try {
                Method createBondMethod = BluetoothDevice.class.getMethod("createBond", new Class[0]);
                Object object = createBondMethod.invoke((Object)device, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                }
                return (Boolean)object;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public final boolean removeBond(@Nullable BluetoothDevice btDevice) {
        try {
            Method removeBondMethod = BluetoothDevice.class.getMethod("removeBond", new Class[0]);
            Object object = removeBondMethod.invoke((Object)btDevice, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            return (Boolean)object;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return false;
    }

    public final void printAllInform() {
        try {
            int i;
            Method[] hideMethod = BluetoothDevice.class.getMethods();
            for (i = 0; i < hideMethod.length; ++i) {
                Method method = hideMethod[i];
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"hideMethod[i]");
                Log.e((String)"method name", (String)method.getName());
            }
            Field[] allFields = BluetoothDevice.class.getFields();
            for (i = 0; i < allFields.length; ++i) {
                Field field = allFields[i];
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"allFields[i]");
                Log.e((String)"Field name", (String)field.getName());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void onReceive(@Nullable Context context, @NotNull Intent intent) {
        block9: {
            int state;
            block10: {
                BluetoothDevice device;
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                String action = intent.getAction();
                if (Intrinsics.areEqual((Object)"android.bluetooth.device.action.FOUND", (Object)action)) {
                    if (this.mScanListener == null) {
                        return;
                    }
                    device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (device != null) {
                        OnScanListener onScanListener = this.mScanListener;
                        if (onScanListener != null) {
                            onScanListener.onFind(device);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)"android.bluetooth.device.action.BOND_STATE_CHANGED", (Object)action)) {
                    if (this.mBondListener == null) {
                        return;
                    }
                    device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    OnBondListener onBondListener = this.mBondListener;
                    if (onBondListener != null) {
                        onBondListener.onBond(device);
                    }
                }
                if (!Intrinsics.areEqual((Object)"android.bluetooth.adapter.action.STATE_CHANGED", (Object)action)) break block9;
                if (this.mOpenListener == null) {
                    return;
                }
                state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                if (state != 12) break block10;
                OnOpenListener onOpenListener = this.mOpenListener;
                if (onOpenListener == null) break block9;
                onOpenListener.onOpen(true);
                break block9;
            }
            if (state != 10) break block9;
            OnOpenListener onOpenListener = this.mOpenListener;
            if (onOpenListener != null) {
                onOpenListener.onOpen(false);
            }
        }
    }

    private BluetoothUtils() {
    }

    static {
        Companion = new Companion(null);
        instance = new BluetoothUtils();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lando/toolkit/BluetoothUtils$OnBondListener;", "", "onBond", "", "device", "Landroid/bluetooth/BluetoothDevice;", "ando_toolkit_release"})
    public static interface OnBondListener {
        public void onBond(@Nullable BluetoothDevice var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lando/toolkit/BluetoothUtils$OnScanListener;", "", "onFind", "", "device", "Landroid/bluetooth/BluetoothDevice;", "ando_toolkit_release"})
    public static interface OnScanListener {
        public void onFind(@Nullable BluetoothDevice var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lando/toolkit/BluetoothUtils$OnOpenListener;", "", "onOpen", "", "isOpen", "", "ando_toolkit_release"})
    public static interface OnOpenListener {
        public void onOpen(boolean var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lando/toolkit/BluetoothUtils$Companion;", "", "()V", "instance", "Lando/toolkit/BluetoothUtils;", "init", "ando_toolkit_release"})
    public static final class Companion {
        @NotNull
        public final BluetoothUtils init() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

