/*
 * Decompiled with CFR 0.152.
 */
package com.github.jason1114.horizontalslidelistview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.HorizontalScrollView;

public class SlideItemView
extends HorizontalScrollView {
    static final int STATE_NORMAL = 205;
    static final int STATE_LEFT_1 = 204;
    static final int STATE_LEFT_2 = 203;
    static final int STATE_RIGHT_1 = 206;
    static final int STATE_RIGHT_2 = 207;
    int mMeasuredWidth = -1;
    int mState = 205;
    int mStateReleaseFrom = -1;
    boolean mReleased = false;
    int mLastChangeFrom = -1;
    int mLastChangeTo = -1;
    ScrollStateListener mScrollStateListener;
    Runnable scrollerTask = new Runnable(){

        @Override
        public void run() {
            int currentState = SlideItemView.this.getState(SlideItemView.this.getScrollX());
            switch (currentState) {
                case 203: {
                    SlideItemView.this.scrollToLeftArea();
                    if (SlideItemView.this.mScrollStateListener == null) break;
                    SlideItemView.this.mStateReleaseFrom = 203;
                    break;
                }
                case 204: {
                    SlideItemView.this.scrollToLeftArea();
                    if (SlideItemView.this.mScrollStateListener == null) break;
                    SlideItemView.this.mStateReleaseFrom = 204;
                    break;
                }
                case 205: {
                    SlideItemView.this.scrollToCenterArea();
                    break;
                }
                case 206: {
                    SlideItemView.this.scrollToRightArea();
                    if (SlideItemView.this.mScrollStateListener == null) break;
                    SlideItemView.this.mStateReleaseFrom = 206;
                    break;
                }
                case 207: {
                    SlideItemView.this.scrollToRightArea();
                    if (SlideItemView.this.mScrollStateListener == null) break;
                    SlideItemView.this.mStateReleaseFrom = 207;
                }
            }
        }
    };
    View.OnTouchListener mOnTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 1) {
                SlideItemView.this.startScrollerTask();
                SlideItemView.this.mReleased = true;
            } else {
                SlideItemView.this.mReleased = false;
            }
            return false;
        }
    };

    public ScrollStateListener getScrollStateListener() {
        return this.mScrollStateListener;
    }

    public void setScrollStateListener(ScrollStateListener mScrollStateListener) {
        this.mScrollStateListener = mScrollStateListener;
    }

    public SlideItemView(Context context) {
        super(context);
        this.setUp();
    }

    public SlideItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUp();
    }

    public SlideItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setUp();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setUp();
        this.restoreScrollPosition();
    }

    public void restoreScrollPosition() {
        this.post(new Runnable(){

            @Override
            public void run() {
                SlideItemView.this.scrollTo(SlideItemView.this.getMeasuredWidth(), 0);
            }
        });
    }

    private void setUp() {
        this.setFillViewport(true);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.setOverScrollMode(2);
    }

    public void fling(int velocityX) {
        super.fling(velocityX / 20);
    }

    public void startScrollerTask() {
        this.postDelayed(this.scrollerTask, 100L);
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        if (this.mMeasuredWidth == -1) {
            this.mMeasuredWidth = this.getMeasuredWidth();
        }
        if (oldX == this.mLastChangeFrom && x == this.mLastChangeTo) {
            return;
        }
        this.mLastChangeFrom = oldX;
        this.mLastChangeTo = x;
        int currentState = this.getState(x);
        switch (currentState) {
            case 203: {
                if (this.mState == 203 || this.mScrollStateListener == null || this.mReleased) break;
                this.mScrollStateListener.onState(203);
                break;
            }
            case 204: {
                if (this.mState == 204 || this.mScrollStateListener == null || this.mReleased) break;
                this.mScrollStateListener.onState(204);
                break;
            }
            case 205: {
                if (this.mState == 205 || this.mScrollStateListener == null || this.mReleased) break;
                this.mScrollStateListener.onState(205);
                break;
            }
            case 206: {
                if (this.mState == 206 || this.mScrollStateListener == null || this.mReleased) break;
                this.mScrollStateListener.onState(206);
                break;
            }
            case 207: {
                if (this.mState == 207 || this.mScrollStateListener == null || this.mReleased) break;
                this.mScrollStateListener.onState(207);
            }
        }
        this.mState = currentState;
        if (x == 0) {
            if (this.mStateReleaseFrom == 204) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SlideItemView.this.mScrollStateListener.onStateReleased(204);
                    }
                });
            } else if (this.mStateReleaseFrom == 203) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SlideItemView.this.mScrollStateListener.onStateReleased(203);
                    }
                });
            }
        } else if (x >= 2 * this.mMeasuredWidth) {
            if (this.mStateReleaseFrom == 206) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SlideItemView.this.mScrollStateListener.onStateReleased(206);
                    }
                });
            } else if (this.mStateReleaseFrom == 207) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SlideItemView.this.mScrollStateListener.onStateReleased(207);
                    }
                });
            }
        }
        this.setOnTouchListener(this.mOnTouchListener);
    }

    public void scrollToLeftArea() {
        this.smoothScrollTo(0, 0);
    }

    public void scrollToRightArea() {
        this.smoothScrollTo(2 * this.getMeasuredWidth(), 0);
    }

    public void scrollToCenterArea() {
        this.smoothScrollTo(this.getMeasuredWidth(), 0);
    }

    private int getState(int scroll) {
        float ratio = (float)scroll / (float)this.mMeasuredWidth;
        if (ratio <= 0.5f) {
            return 203;
        }
        if (ratio <= 0.8f) {
            return 204;
        }
        if (ratio <= 1.2f) {
            return 205;
        }
        if (ratio <= 1.5f) {
            return 206;
        }
        return 207;
    }

    public static interface ScrollStateListener {
        public void onState(int var1);

        public void onStateReleased(int var1);
    }
}

