/*
 * Decompiled with CFR 0.152.
 */
package com.github.jason1114.horizontalslidelistview;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.github.jason1114.horizontalslidelistview.MultipleWidthLinearLayout;
import com.github.jason1114.horizontalslidelistview.SlideItemView;

public abstract class HScrollAdapter
extends BaseAdapter {
    public static final int STATE_LEFT_2 = 203;
    public static final int STATE_LEFT_1 = 204;
    public static final int STATE_NORMAL = 205;
    public static final int STATE_RIGHT_1 = 206;
    public static final int STATE_RIGHT_2 = 207;
    public static final int TYPE_RIGHT = 105;
    public static final int TYPE_CENTER = 104;
    public static final int TYPE_LEFT = 103;
    protected Context mContext;

    @LayoutRes
    public abstract int getLayout(int var1);

    public abstract void renderView(int var1, View var2, View var3, View var4);

    public abstract void onState(int var1, int var2, View var3, View var4, View var5);

    public abstract void onStateReleased(int var1, int var2, View var3, View var4, View var5);

    public HScrollAdapter(Context context) {
        this.mContext = context;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            holder.hsv = new SlideItemView(this.mContext);
            AbsListView.LayoutParams hsvLayoutParams = new AbsListView.LayoutParams(-1, -2);
            holder.hsv.setLayoutParams((ViewGroup.LayoutParams)hsvLayoutParams);
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            holder.hLayout = new MultipleWidthLinearLayout(this.mContext);
            holder.hLayout.setMultiplier(3);
            holder.hLayout.setOrientation(0);
            FrameLayout.LayoutParams scrollLayoutParams = new FrameLayout.LayoutParams(-1, -2);
            holder.hLayout.setLayoutParams((ViewGroup.LayoutParams)scrollLayoutParams);
            RelativeLayout leftArea = new RelativeLayout(this.mContext);
            RelativeLayout centerArea = new RelativeLayout(this.mContext);
            RelativeLayout rightArea = new RelativeLayout(this.mContext);
            LinearLayout.LayoutParams areaParams = new LinearLayout.LayoutParams(-1, -2);
            areaParams.weight = 1.0f;
            leftArea.setLayoutParams((ViewGroup.LayoutParams)areaParams);
            centerArea.setLayoutParams((ViewGroup.LayoutParams)areaParams);
            rightArea.setLayoutParams((ViewGroup.LayoutParams)areaParams);
            holder.hLayout.addView((View)leftArea);
            holder.hLayout.addView((View)centerArea);
            holder.hLayout.addView((View)rightArea);
            holder.left = inflater.inflate(this.getLayout(103), (ViewGroup)leftArea);
            holder.right = inflater.inflate(this.getLayout(105), (ViewGroup)rightArea);
            holder.center = inflater.inflate(this.getLayout(104), (ViewGroup)centerArea);
            holder.hsv.setScrollStateListener(new SlideItemView.ScrollStateListener(){

                @Override
                public void onState(int state) {
                    HScrollAdapter.this.onState(holder.position, state, holder.left, holder.center, holder.right);
                }

                @Override
                public void onStateReleased(int state) {
                    HScrollAdapter.this.onStateReleased(holder.position, state, holder.left, holder.center, holder.right);
                }
            });
            holder.hsv.addView((View)holder.hLayout);
            convertView = holder.hsv;
            convertView.setTag((Object)holder);
        }
        holder = (ViewHolder)convertView.getTag();
        holder.position = position;
        this.renderView(position, holder.left, holder.center, holder.right);
        holder.hsv.restoreScrollPosition();
        return convertView;
    }

    static class ViewHolder {
        SlideItemView hsv;
        MultipleWidthLinearLayout hLayout;
        View left;
        View center;
        View right;
        int position;

        ViewHolder() {
        }
    }
}

