/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi.retrofit;

import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.ResourceConverter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

public class JSONAPIRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private final ResourceConverter converter;

    public JSONAPIRequestBodyConverter(ResourceConverter converter) {
        this.converter = converter;
    }

    public RequestBody convert(T t) throws IOException {
        try {
            MediaType mediaType = MediaType.parse((String)"application/vnd.api+json");
            JSONAPIDocument<T> document = t instanceof JSONAPIDocument ? (JSONAPIDocument<T>)t : new JSONAPIDocument<T>(t);
            return RequestBody.create((MediaType)mediaType, (byte[])this.converter.writeDocument(document));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

