/*
 * Decompiled with CFR 0.152.
 */
package org.frutilla;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.frutilla.annotations.Frutilla;

class FrutillaParser {
    private static final String AND = " AND";
    private static final String BUT = " BUT";
    private static AbstractSentence sRoot;

    FrutillaParser() {
    }

    static Scenario scenario(String text) {
        FrutillaParser.reset();
        Scenario scenario = new Scenario(text);
        sRoot = scenario;
        return scenario;
    }

    static Given given(String text) {
        FrutillaParser.reset();
        Given given = new Given(text);
        sRoot = given;
        return given;
    }

    static boolean has(String sentence) {
        return sRoot != null && sRoot.has(sentence);
    }

    static void reset() {
        if (sRoot != null) {
            sRoot.reset();
            sRoot = null;
        }
    }

    static boolean isEmpty() {
        return sRoot == null || sRoot.isEmpty();
    }

    static String popSentence() {
        if (sRoot != null) {
            return sRoot.popSentence();
        }
        return "";
    }

    static String scenario(Frutilla annotation) {
        String value = "";
        if (annotation != null) {
            Scenario scenario = new Scenario(annotation.Scenario());
            scenario.given(annotation.Given()).when(annotation.When()).then(annotation.Then());
            value = scenario.popSentence();
        }
        return value;
    }

    public static class Then
    extends AbstractSentence {
        private Then(String sentence) {
            super(sentence, "THEN");
        }

        private Then(String[] sentences) {
            super(sentences, "THEN");
        }

        private Then(String sentence, String header) {
            super(sentence, header);
        }

        @Override
        public Then and(String sentence) {
            return (Then)this.addChild(new Then(sentence, FrutillaParser.AND));
        }

        @Override
        public Then but(String sentence) {
            return (Then)this.addChild(new Then(sentence, FrutillaParser.BUT));
        }
    }

    public static class When
    extends AbstractSentence {
        private When(String sentence) {
            super(sentence, "WHEN");
        }

        private When(String[] sentences) {
            super(sentences, "WHEN");
        }

        private When(String sentence, String header) {
            super(sentence, header);
        }

        public Then then(String sentence) {
            return (Then)this.addChild(new Then(sentence));
        }

        Then then(String[] sentences) {
            return (Then)this.addChild(new Then(sentences));
        }

        @Override
        public When and(String sentence) {
            return (When)this.addChild(new When(sentence, FrutillaParser.AND));
        }

        @Override
        public When but(String sentence) {
            return (When)this.addChild(new When(sentence, FrutillaParser.BUT));
        }
    }

    public static class Given
    extends AbstractSentence {
        private Given(String sentence) {
            super(sentence, "GIVEN");
        }

        private Given(String[] sentences) {
            super(sentences, "GIVEN");
        }

        private Given(String sentence, String header) {
            super(sentence, header);
        }

        public When when(String sentence) {
            When when = new When(sentence);
            this.addChild(when);
            return when;
        }

        When when(String[] sentences) {
            When when = new When(sentences);
            this.addChild(when);
            return when;
        }

        @Override
        public Given and(String sentence) {
            return (Given)this.addChild(new Given(sentence, FrutillaParser.AND));
        }

        @Override
        public Given but(String sentence) {
            return (Given)this.addChild(new Given(sentence, FrutillaParser.BUT));
        }
    }

    public static class Scenario
    extends AbstractSentence {
        private Scenario(String sentence) {
            super(sentence, "SCENARIO");
        }

        private Scenario(String[] sentences) {
            super(sentences, "SCENARIO");
        }

        private Scenario(String sentence, String header) {
            super(sentence, header);
        }

        public Given given(String sentence) {
            Given given = new Given(sentence);
            this.addChild(given);
            return given;
        }

        Given given(String[] sentences) {
            Given given = new Given(sentences);
            this.addChild(given);
            return given;
        }

        @Override
        public Scenario and(String sentence) {
            return (Scenario)this.addChild(new Scenario(sentence, FrutillaParser.AND));
        }

        @Override
        public Scenario but(String sentence) {
            return (Scenario)this.addChild(new Scenario(sentence, FrutillaParser.BUT));
        }
    }

    static abstract class AbstractSentence {
        private String mSentence;
        private final List<AbstractSentence> mChildren = new LinkedList<AbstractSentence>();
        private final String mHeader;

        private AbstractSentence(String sentence, String header) {
            this.mSentence = sentence != null && sentence.trim().toLowerCase(Locale.ENGLISH).startsWith(header.trim().toLowerCase(Locale.ENGLISH) + " ") ? sentence.trim().substring((header.trim().toLowerCase(Locale.ENGLISH) + " ").length()) : sentence;
            this.mHeader = header;
        }

        AbstractSentence(String[] sentences, String header) {
            this(sentences == null || sentences.length == 0 ? "" : sentences[0], header);
            if (sentences != null) {
                AbstractSentence child = this;
                for (int i = 1; i < sentences.length; ++i) {
                    String sentence = sentences[i];
                    child = sentence != null && sentence.trim().toLowerCase(Locale.ENGLISH).startsWith("and ") ? child.and(sentence) : (sentence != null && sentence.trim().toLowerCase(Locale.ENGLISH).startsWith("but ") ? child.but(sentence) : child.and(sentence));
                }
            }
        }

        boolean has(String sentence) {
            boolean has;
            block1: {
                AbstractSentence child;
                has = this.mSentence.equals(sentence);
                if (has) break block1;
                Iterator<AbstractSentence> i$ = this.mChildren.iterator();
                while (i$.hasNext() && !(has = (child = i$.next()).has(sentence))) {
                }
            }
            return has;
        }

        void reset() {
            this.mSentence = null;
            for (AbstractSentence child : this.mChildren) {
                child.reset();
            }
            this.mChildren.clear();
        }

        public abstract AbstractSentence and(String var1);

        boolean isEmpty() {
            return this.mSentence == null && this.mChildren.isEmpty();
        }

        AbstractSentence addChild(AbstractSentence child) {
            this.mChildren.add(child);
            return child;
        }

        String popSentence() {
            StringBuilder sentence = new StringBuilder();
            if (this.mSentence != null && this.mSentence.trim().length() > 0) {
                sentence.append(this.header());
                sentence.append(" ");
                sentence.append(this.mSentence);
            }
            for (AbstractSentence child : this.mChildren) {
                String text = child.popSentence();
                if (text.trim().isEmpty()) continue;
                if (sentence.length() > 0) {
                    sentence.append("\n");
                }
                sentence.append(text);
            }
            this.reset();
            return sentence.toString();
        }

        String header() {
            return this.mHeader;
        }

        public abstract AbstractSentence but(String var1);
    }
}

