/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.sensitive;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.taglib.display.sensitive.SensitiveConfig;
import com.feilong.taglib.display.sensitive.SensitivePropertiesConfig;
import com.feilong.taglib.display.sensitive.SensitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SensitiveUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensitiveUtil.class);

    private SensitiveUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String parse(String value, SensitiveConfig sensitiveConfig) {
        if (Validator.isNullOrEmpty(value)) {
            return value;
        }
        Validate.notNull(sensitiveConfig, "sensitiveConfig can't be null!", new Object[0]);
        String type = sensitiveConfig.getType();
        Validate.notBlank(type, "type can't be blank!", new Object[0]);
        char maskChar = sensitiveConfig.getMaskChar();
        Integer[] leftAndRightNoMaskLengths = SensitivePropertiesConfig.load(type);
        if (Validator.isNotNullOrEmpty(leftAndRightNoMaskLengths)) {
            return SensitiveUtil.parse(value, leftAndRightNoMaskLengths, maskChar);
        }
        return SensitiveUtil.parseWithEnum(value, sensitiveConfig, type, maskChar);
    }

    private static String parseWithEnum(String value, SensitiveConfig sensitiveConfig, String type, char maskChar) {
        SensitiveType sensitiveType = SensitiveType.toSensitiveType(type);
        Validate.notNull(sensitiveType, "sensitiveConfig.getSensitiveType() can't be null!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("value:[{}],sensitiveConfig:{}", (Object)value, (Object)JsonUtil.format(sensitiveConfig));
        }
        if (sensitiveType.isNoNeedMask(value)) {
            return value;
        }
        return SensitiveUtil.parse(value, sensitiveType.getLeftAndRightNoMaskLengths(value), maskChar);
    }

    private static String parse(String value, Integer[] leftAndRightNoMaskLengths, char maskChar) {
        int leftNoMaskLength = leftAndRightNoMaskLengths[0];
        int rightNoMaskLength = leftAndRightNoMaskLengths[1];
        return SensitiveUtil.parse(value, maskChar, leftNoMaskLength, rightNoMaskLength);
    }

    public static String parse(String value, char maskChar, int leftNoMaskLength, int rightNoMaskLength) {
        if (LOGGER.isTraceEnabled()) {
            String format = "will parse:[{}],maskChar:[{}],leftNoMaskLength:[{}],rightNoMaskLength:[{}]";
            LOGGER.trace(format, new Object[]{value, Character.valueOf(maskChar), leftNoMaskLength, rightNoMaskLength});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.left(value, leftNoMaskLength));
        sb.append(StringUtils.repeat(maskChar, value.length() - leftNoMaskLength - rightNoMaskLength));
        sb.append(StringUtils.right(value, rightNoMaskLength));
        if (LOGGER.isDebugEnabled()) {
            String format = "parse:[{}],maskChar:[{}],leftNoMaskLength:[{}],rightNoMaskLength:[{}],result:[{}]";
            LOGGER.debug(format, new Object[]{value, Character.valueOf(maskChar), leftNoMaskLength, rightNoMaskLength, sb.toString()});
        }
        return sb.toString();
    }
}

