/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.pager;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.net.ParamUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.tuple.Pair;
import com.feilong.taglib.display.CacheContentBuilder;
import com.feilong.taglib.display.pager.command.Pager;
import com.feilong.taglib.display.pager.command.PagerParams;
import com.feilong.taglib.display.pager.command.PagerType;
import com.feilong.taglib.display.pager.command.PagerUrlTemplate;
import com.feilong.taglib.display.pager.command.PagerVMParam;
import com.feilong.template.TemplateUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagerCacheContentBuilder
implements CacheContentBuilder<PagerParams, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagerCacheContentBuilder.class);
    public static final CacheContentBuilder<PagerParams, String> INSTANCE = new PagerCacheContentBuilder();

    @Override
    public String build(PagerParams pagerParams) {
        if (pagerParams.getDebugIsNotParseVM()) {
            LOGGER.debug("param [debugIsNotParseVM] is [true],return empty~");
            return "";
        }
        Map<String, Object> vmParamMap = MapUtil.newHashMap();
        vmParamMap.put("pagerVMParam", PagerCacheContentBuilder.buildPagerVMParam(pagerParams));
        vmParamMap.put("i18nMap", ResourceBundleUtil.toMap(ResourceBundleUtil.getResourceBundle("messages/feilong-pager", pagerParams.getLocale())));
        String content = TemplateUtil.parseTemplate(pagerParams.getVmPath(), vmParamMap);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parse:[{}],use vmParamMap:{},content result:{}", new Object[]{pagerParams.getVmPath(), JsonUtil.format(vmParamMap), content});
        }
        return content;
    }

    private static <T> PagerVMParam buildPagerVMParam(PagerParams pagerParams) {
        Pager<T> pager = PagerCacheContentBuilder.buildPager(pagerParams);
        int allPageNo = pager.getAllPageNo();
        int currentPageNo = pager.getCurrentPageNo();
        Integer maxNavigationPageNumbers = PagerCacheContentBuilder.buildMaxNavigationPageNumbers(currentPageNo, pagerParams.getDynamicNavigationPageNumberConfig());
        Pair<Integer, Integer> startAndEndIndexPair = PagerCacheContentBuilder.buildStartAndEndIndexPair(allPageNo, currentPageNo, maxNavigationPageNumbers);
        Map<Integer, String> allUseIndexAndHrefMap = PagerCacheContentBuilder.buildAllUseIndexAndHrefMap(pagerParams, pager, startAndEndIndexPair);
        int prePageNo = pager.getPrePageNo();
        int nextPageNo = pager.getNextPageNo();
        PagerVMParam pagerVMParam = new PagerVMParam();
        pagerVMParam.setSkin(pagerParams.getSkin());
        pagerVMParam.setPagerType(pagerParams.getPagerType());
        pagerVMParam.setTotalCount(pagerParams.getTotalCount());
        pagerVMParam.setCurrentPageNo(currentPageNo);
        pagerVMParam.setAllPageNo(allPageNo);
        pagerVMParam.setPrePageNo(prePageNo);
        pagerVMParam.setNextPageNo(nextPageNo);
        pagerVMParam.setStartIteratorIndex(startAndEndIndexPair.getLeft());
        pagerVMParam.setEndIteratorIndex(startAndEndIndexPair.getRight());
        pagerVMParam.setPreUrl(allUseIndexAndHrefMap.get(prePageNo));
        pagerVMParam.setNextUrl(allUseIndexAndHrefMap.get(nextPageNo));
        pagerVMParam.setFirstUrl(allUseIndexAndHrefMap.get(1));
        pagerVMParam.setLastUrl(allUseIndexAndHrefMap.get(pager.getAllPageNo()));
        pagerVMParam.setPagerUrlTemplate(PagerCacheContentBuilder.buildPagerUrlTemplate(allUseIndexAndHrefMap));
        pagerVMParam.setPageParamName(pagerParams.getPageParamName());
        pagerVMParam.setIteratorIndexMap(PagerCacheContentBuilder.getIteratorIndexAndHrefMap(allUseIndexAndHrefMap, startAndEndIndexPair.getLeft(), startAndEndIndexPair.getRight()));
        return pagerVMParam;
    }

    static <T> Pager<T> buildPager(PagerParams pagerParams) {
        int totalCount = pagerParams.getTotalCount();
        int currentPageNo = PagerCacheContentBuilder.detectCurrentPageNo(pagerParams);
        int pageSize = pagerParams.getPageSize();
        Pager pager = new Pager(currentPageNo, pageSize, totalCount);
        pager.setMaxShowPageNo(pagerParams.getMaxShowPageNo());
        return pager;
    }

    private static PagerUrlTemplate buildPagerUrlTemplate(Map<Integer, String> indexAndHrefMap) {
        Integer defaultTemplatePageNo = -88888888;
        PagerUrlTemplate pagerUrlTemplate = new PagerUrlTemplate();
        pagerUrlTemplate.setTemplateValue(defaultTemplatePageNo);
        pagerUrlTemplate.setHref(indexAndHrefMap.get(defaultTemplatePageNo));
        return pagerUrlTemplate;
    }

    private static Map<Integer, String> getIteratorIndexAndHrefMap(Map<Integer, String> indexAndHrefMap, int startIteratorIndex, int endIteratorIndex) {
        Map<Integer, String> map = MapUtil.newLinkedHashMap(endIteratorIndex - startIteratorIndex + 1);
        for (int i = startIteratorIndex; i <= endIteratorIndex; ++i) {
            map.put(i, indexAndHrefMap.get(i));
        }
        return map;
    }

    private static int detectCurrentPageNo(PagerParams pagerParams) {
        Integer currentPageNo = pagerParams.getCurrentPageNo();
        if (null == currentPageNo || currentPageNo < 1) {
            return 1;
        }
        return currentPageNo;
    }

    private static <T> Map<Integer, String> buildAllUseIndexAndHrefMap(PagerParams pagerParams, Pager<T> pager, Pair<Integer, Integer> startAndEndIndexPair) {
        String pageParamName = pagerParams.getPageParamName();
        PagerType pagerType = pagerParams.getPagerType();
        String targetForReplace = pageParamName + "=" + -88888888;
        String templateEncodedUrl = PagerCacheContentBuilder.getTemplateEncodedUrl(pagerParams, pageParamName, pagerType);
        Set<Integer> indexSet = PagerCacheContentBuilder.buildAllUseIndexSet(pager, startAndEndIndexPair.getLeft(), startAndEndIndexPair.getRight());
        Map<Integer, String> returnMap = MapUtil.newHashMap();
        for (Integer index : indexSet) {
            String link = pagerType == PagerType.NO_REDIRECT ? templateEncodedUrl : templateEncodedUrl.replace(targetForReplace, pageParamName + "=" + index);
            returnMap.put(index, link);
        }
        return returnMap;
    }

    private static String getTemplateEncodedUrl(PagerParams pagerParams, String pageParamName, PagerType pagerType) {
        boolean isNoRedirect;
        boolean bl = isNoRedirect = PagerType.NO_REDIRECT == pagerType;
        if (isNoRedirect) {
            return "javascript:void(0);";
        }
        String defaultTemplatePageNo = "-88888888";
        return ParamUtil.addParameter(pagerParams.getPageUrl(), pageParamName, defaultTemplatePageNo, pagerParams.getCharsetType());
    }

    private static <T> Set<Integer> buildAllUseIndexSet(Pager<T> pager, int startIteratorIndex, int endIteratorIndex) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        indexSet.add(-88888888);
        indexSet.add(pager.getPrePageNo());
        indexSet.add(pager.getNextPageNo());
        indexSet.add(1);
        indexSet.add(pager.getAllPageNo());
        for (int i = startIteratorIndex; i <= endIteratorIndex; ++i) {
            indexSet.add(i);
        }
        return indexSet;
    }

    private static Pair<Integer, Integer> buildStartAndEndIndexPair(int allPageNo, int currentPageNo, Integer maxIndexPages) {
        int rightCount;
        if (allPageNo <= maxIndexPages) {
            return Pair.of(1, allPageNo);
        }
        int fenTwo = maxIndexPages - 1;
        int leftCount = fenTwo / 2;
        int n = rightCount = fenTwo % 2 == 0 ? leftCount : leftCount + 1;
        if (currentPageNo <= leftCount + 1) {
            return Pair.of(1, maxIndexPages);
        }
        if (currentPageNo + rightCount >= allPageNo) {
            return Pair.of(allPageNo - maxIndexPages + 1, allPageNo);
        }
        return Pair.of(currentPageNo - leftCount, currentPageNo + rightCount);
    }

    private static Integer buildMaxNavigationPageNumbers(int currentPageNo, String dynamicNavigationPageNumberConfig) {
        if (Validator.isNullOrEmpty(dynamicNavigationPageNumberConfig)) {
            return 10;
        }
        Map<Integer, Integer> navigationPageNumberMap = PagerCacheContentBuilder.toNavigationPageNumberMap(dynamicNavigationPageNumberConfig);
        if (Validator.isNullOrEmpty(navigationPageNumberMap)) {
            return 10;
        }
        for (Map.Entry<Integer, Integer> entry : navigationPageNumberMap.entrySet()) {
            Integer key = entry.getKey();
            Integer value = entry.getValue();
            if (currentPageNo < key) continue;
            return value;
        }
        return 10;
    }

    private static Map<Integer, Integer> toNavigationPageNumberMap(String dynamicNavigationPageNumberConfig) {
        Map<String, String> singleValueMap = ParamUtil.toSingleValueMap(dynamicNavigationPageNumberConfig, CharsetType.UTF8);
        Map<Integer, Integer> integerMap = ConvertUtil.toMap(singleValueMap, Integer.class, Integer.class);
        return SortUtil.sortMapByKeyDesc(integerMap);
    }
}

