/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.builder;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.BooleanUtils;
import com.feilong.taglib.display.httpconcat.command.HttpConcatGlobalConfig;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpConcatGlobalConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConcatGlobalConfigBuilder.class);
    private static final String CONFIG_FILE = "config/httpconcat";
    private static final ResourceBundle HTTPCONCAT_RESOURCEBUNDLE = ResourceBundleUtil.getResourceBundle("config/httpconcat");
    public static final HttpConcatGlobalConfig GLOBAL_CONFIG = HttpConcatGlobalConfigBuilder.build();

    private HttpConcatGlobalConfigBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    private static HttpConcatGlobalConfig build() {
        HttpConcatGlobalConfig httpConcatGlobalConfig = new HttpConcatGlobalConfig();
        httpConcatGlobalConfig.setHttpConcatSupport(HttpConcatGlobalConfigBuilder.getRequiredValue("httpconcat.support", Boolean.class));
        httpConcatGlobalConfig.setTemplateCss(HttpConcatGlobalConfigBuilder.getRequiredValue("httpconcat.template.css", String.class));
        httpConcatGlobalConfig.setTemplateJs(HttpConcatGlobalConfigBuilder.getRequiredValue("httpconcat.template.js", String.class));
        httpConcatGlobalConfig.setDefaultCacheEnable(BooleanUtils.toBoolean(HttpConcatGlobalConfigBuilder.getRequiredValue("httpconcat.defaultCacheEnable", Boolean.class)));
        httpConcatGlobalConfig.setDefaultCacheSizeLimit(HttpConcatGlobalConfigBuilder.getRequiredValue("httpconcat.defaultCacheSizeLimit", Integer.class));
        httpConcatGlobalConfig.setVersionEncode(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.version.encode", new Object[0]));
        httpConcatGlobalConfig.setVersionNameInScope(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.version.nameInScope", new Object[0]));
        httpConcatGlobalConfig.setVersionSearchScope(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.version.search.scope", new Object[0]));
        httpConcatGlobalConfig.setVersionAutoRefreshValue(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.version.autoRefresh.value", new Object[0]));
        httpConcatGlobalConfig.setDomain(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.domain", new Object[0]));
        httpConcatGlobalConfig.setAutoPartitionSize(ConvertUtil.toInteger(ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, "httpconcat.autoPartitionSize", new Object[0])));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("init http concat config:[{}]", (Object)JsonUtil.format(httpConcatGlobalConfig));
        }
        return httpConcatGlobalConfig;
    }

    private static <T> T getRequiredValue(String keyName, Class<T> typeClass) {
        String value = ResourceBundleUtil.getValue(HTTPCONCAT_RESOURCEBUNDLE, keyName, new Object[0]);
        Validate.notBlank(value, "can't find key:[%s] in [%s],pls ensure you have put the correct configuration", keyName, CONFIG_FILE);
        return ConvertUtil.convert(value, typeClass);
    }
}

