/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib;

import com.feilong.json.JsonUtil;
import com.feilong.servlet.http.RequestUtil;
import com.feilong.servlet.http.entity.RequestLogSwitch;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = -5494214419937813707L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTag.class);

    protected final HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected final HttpSession getHttpSession() {
        return this.pageContext.getSession();
    }

    protected final HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.pageContext.getResponse();
    }

    protected void logException(Exception e) {
        if (LOGGER.isErrorEnabled()) {
            RequestLogSwitch requestLogSwitch = RequestLogSwitch.NORMAL_WITH_IDENTITY_INCLUDE_FORWARD;
            Map<String, Object> map = RequestUtil.getRequestInfoMapForLog(this.getHttpServletRequest(), requestLogSwitch);
            String pattern = "tag:[{}],exception message:[{}],request info:{},but need render page,pls check!";
            LOGGER.error(Slf4jUtil.format(pattern, ((Object)((Object)this)).getClass().getSimpleName(), e.getMessage(), JsonUtil.format(map)), (Throwable)e);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        LOGGER.error("[" + ((Object)((Object)this)).getClass().getSimpleName() + "]", t);
    }

    public void doFinally() {
    }
}

