/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import com.feilong.json.JsonUtil;
import com.feilong.servlet.http.RequestUtil;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestLoggingListener
implements ServletRequestListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletRequestLoggingListener.class);

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        if (LOGGER.isTraceEnabled()) {
            ServletRequest servletRequest = servletRequestEvent.getServletRequest();
            LOGGER.trace("servletRequest request [Initialized] info:[{}] ", (Object)JsonUtil.format(RequestUtil.getRequestInfoMapForLog((HttpServletRequest)servletRequest)));
        }
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        if (LOGGER.isTraceEnabled()) {
            ServletRequest servletRequest = servletRequestEvent.getServletRequest();
            LOGGER.trace("servletRequest request [Destroyed] info:[{}] ", (Object)JsonUtil.format(RequestUtil.getRequestInfoMapForLog((HttpServletRequest)servletRequest)));
        }
    }
}

