/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet;

import com.feilong.core.Validator;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.lang3.ArrayUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletContext;

public final class ServletContextUtil {
    public static final String[] EXCLUDE_KEYS = new String[]{"org.apache.catalina.jsp_classpath", "org.apache.catalina.resources", "org.apache.jasper.compiler.ELInterpreter", "org.apache.jasper.compiler.TldLocationsCache", "org.apache.jasper.runtime.JspApplicationContextImpl", "org.apache.tomcat.InstanceManager", "org.apache.tomcat.JarScanner", "org.apache.tomcat.util.scan.MergedWebXml"};

    private ServletContextUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Map<String, Object> getServletContextInfoMapForLog(ServletContext servletContext) {
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        map.put("serverInfo", servletContext.getServerInfo());
        map.put("version", servletContext.getMajorVersion() + "." + servletContext.getMinorVersion());
        map.put("contextPath", servletContext.getContextPath());
        map.put("servletContextName", servletContext.getServletContextName());
        return map;
    }

    public static Map<String, Object> getAttributeMap(ServletContext servletContext) {
        return ServletContextUtil.getAttributeMap(servletContext, true);
    }

    public static Map<String, Object> getAttributeMap(ServletContext servletContext, boolean ignoreContainerAttribute) {
        Enumeration attributeNames = servletContext.getAttributeNames();
        if (Validator.isNullOrEmpty(attributeNames)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if (ignoreContainerAttribute && ArrayUtils.contains(EXCLUDE_KEYS, name)) continue;
            map.put(name, servletContext.getAttribute(name));
        }
        return map;
    }

    public static Map<String, String> getInitParameterMap(ServletContext servletContext) {
        Enumeration initParameterNames = servletContext.getInitParameterNames();
        if (Validator.isNullOrEmpty(initParameterNames)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            map.put(name, servletContext.getInitParameter(name));
        }
        return map;
    }
}

