/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security.symmetric.builder;

import com.feilong.core.Validate;
import com.feilong.security.symmetric.CipherMode;
import com.feilong.security.symmetric.CipherPadding;

public class TransformationBuilder {
    private TransformationBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String build(String algorithm, CipherMode cipherMode, CipherPadding cipherPadding) {
        Validate.notBlank(algorithm, "algorithm can't be blank!", new Object[0]);
        if (null == cipherMode && null == cipherPadding) {
            return algorithm;
        }
        String transformation = algorithm;
        if (null != cipherMode) {
            transformation = transformation + "/" + (Object)((Object)cipherMode);
        }
        if (null != cipherPadding) {
            transformation = transformation + "/" + (Object)((Object)cipherPadding);
        }
        return transformation;
    }
}

