/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security;

import com.feilong.core.Validate;
import com.feilong.core.Validator;

public final class ByteUtil {
    private static final char[] DIGIT_2_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private ByteUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String bytesToHexStringLowerCase(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(ByteUtil.byteToHexStringLowerCase(b[i]));
        }
        return sb.toString();
    }

    public static String bytesToHexStringUpperCase(byte[] bytes) {
        Validate.isTrue(Validator.isNotNullOrEmpty(bytes), "bytes can't be null/empty!", new Object[0]);
        char[] tmpData = new char[bytes.length << 1];
        for (int i = 0; i < bytes.length; ++i) {
            int left = (bytes[i] & 0xF0) >> 4;
            tmpData[i << 1] = DIGIT_2_CHARS[left];
            int right = bytes[i] & 0xF;
            tmpData[(i << 1) + 1] = DIGIT_2_CHARS[right];
        }
        return new String(tmpData);
    }

    public static String byteToHexStringLowerCase(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        int d1 = i / 16;
        int d2 = i % 16;
        return HEX_DIGITS[d1] + HEX_DIGITS[d2];
    }

    public static byte[] hexBytesToBytes(byte[] bytes) {
        int length = bytes.length;
        Validate.isTrue(length % 2 == 0, "length is not even,length is:" + length, new Object[0]);
        byte[] bytes2 = new byte[length / 2];
        for (int n = 0; n < length; n += 2) {
            String item = new String(bytes, n, 2);
            bytes2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        return bytes2;
    }

    public static byte[] hexBytesToBytes2(byte[] bytes) {
        int size = bytes.length / 2;
        byte[] ret = new byte[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = ByteUtil.uniteBytes(bytes[i * 2], bytes[i * 2 + 1]);
        }
        return ret;
    }

    public static byte uniteBytes(byte byte1, byte byte2) {
        byte b0 = Byte.decode("0x" + new String(new byte[]{byte1}));
        b0 = (byte)(b0 << 4);
        byte b1 = Byte.decode("0x" + new String(new byte[]{byte2}));
        return (byte)(b0 ^ b1);
    }
}

