/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder.httpurirequest;

import com.feilong.core.Validate;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.NotImplementedException;
import com.feilong.net.UncheckedHttpException;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.HttpMethodType;
import com.feilong.net.http.HttpRequest;
import com.feilong.net.http.builder.httpurirequest.HttpEntityBuilder;
import com.feilong.net.http.builder.httpurirequest.URIBuilderBuilder;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class HttpUriRequestFactory {
    private HttpUriRequestFactory() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static HttpUriRequest create(HttpRequest httpRequest, ConnectionConfig connectionConfig) {
        HttpRequestBase httpRequestBase = HttpUriRequestFactory.create(httpRequest);
        return httpRequestBase;
    }

    private static HttpRequestBase create(HttpRequest httpRequest) {
        HttpMethodType httpMethodType = httpRequest.getHttpMethodType();
        Validate.notNull(httpMethodType, "httpMethodType can't be null!,%s", httpRequest.getFullEncodedUrl());
        switch (httpMethodType) {
            case GET: {
                return HttpUriRequestFactory.buildGet(httpRequest);
            }
            case POST: {
                return HttpUriRequestFactory.buildPost(httpRequest);
            }
            case PUT: {
                return HttpUriRequestFactory.buildPut(httpRequest);
            }
        }
        throw new NotImplementedException((Object)((Object)httpMethodType) + " is not implemented!");
    }

    private static HttpGet buildGet(HttpRequest httpRequest) {
        URIBuilder uriBuilder = URIBuilderBuilder.build(httpRequest);
        try {
            URI buildUri = uriBuilder.build();
            return new HttpGet(buildUri);
        }
        catch (URISyntaxException e) {
            String message = Slf4jUtil.format("httpRequest:[{}]", JsonUtil.format(httpRequest));
            throw new UncheckedHttpException(message, e);
        }
    }

    private static HttpPost buildPost(HttpRequest httpRequest) {
        HttpPost httpPost = new HttpPost(httpRequest.getUri());
        httpPost.setEntity(HttpEntityBuilder.build(httpRequest));
        return httpPost;
    }

    private static HttpPut buildPut(HttpRequest httpRequest) {
        HttpPut httpPut = new HttpPut(httpRequest.getUri());
        httpPut.setEntity(HttpEntityBuilder.build(httpRequest));
        return httpPut;
    }
}

