/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder;

import com.feilong.core.Validator;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.net.http.ConnectionConfig;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;

public final class RequestConfigBuilder {
    private RequestConfigBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static RequestConfig build(ConnectionConfig connectionConfig) {
        ConnectionConfig useConnectionConfig = ObjectUtil.defaultIfNull(connectionConfig, ConnectionConfig.INSTANCE);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        RequestConfigBuilder.setTimeout(requestConfigBuilder, useConnectionConfig);
        RequestConfigBuilder.setProxy(requestConfigBuilder, useConnectionConfig);
        requestConfigBuilder.setCookieSpec("ignoreCookies");
        return requestConfigBuilder.build();
    }

    private static void setTimeout(RequestConfig.Builder requestConfigBuilder, ConnectionConfig useConnectionConfig) {
        requestConfigBuilder.setConnectionRequestTimeout(1000);
        requestConfigBuilder.setConnectTimeout(useConnectionConfig.getConnectTimeout());
        requestConfigBuilder.setSocketTimeout(useConnectionConfig.getReadTimeout());
    }

    private static void setProxy(RequestConfig.Builder requestConfigBuilder, ConnectionConfig connectionConfig) {
        boolean isNeedProxy;
        String proxyAddress = connectionConfig.getProxyAddress();
        Integer proxyPort = connectionConfig.getProxyPort();
        boolean bl = isNeedProxy = Validator.isNotNullOrEmpty(proxyAddress) && Validator.isNotNullOrEmpty(proxyPort);
        if (isNeedProxy) {
            HttpHost proxy = new HttpHost(proxyAddress, proxyPort.intValue());
            requestConfigBuilder.setProxy(proxy);
        }
    }
}

