/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.http.builder;

import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.net.http.ConnectionConfig;
import com.feilong.net.http.builder.RequestConfigBuilder;
import com.feilong.net.http.packer.SSLPacker;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientBuilder.class);
    private static Map<ConnectionConfig, HttpClient> cache = MapUtil.newConcurrentHashMap(10);

    private HttpClientBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient build(ConnectionConfig connectionConfig) {
        ConnectionConfig useConnectionConfig = ObjectUtil.defaultIfNull(connectionConfig, ConnectionConfig.INSTANCE);
        HttpClient httpClient = cache.get(useConnectionConfig);
        if (null != httpClient) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(StringUtils.center("loader from cache,cache size:[" + cache.size() + "]", 80, "="));
            }
            return httpClient;
        }
        Class<HttpClientBuilder> clazz = HttpClientBuilder.class;
        synchronized (HttpClientBuilder.class) {
            httpClient = cache.get(useConnectionConfig);
            if (null == httpClient) {
                httpClient = HttpClientBuilder.build(useConnectionConfig, null);
                cache.put(useConnectionConfig, httpClient);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(StringUtils.center("build new httpClient and set to cache,cache size:[" + cache.size() + "]", 120, "-"));
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return httpClient;
        }
    }

    public static HttpClient build(ConnectionConfig connectionConfig, LayeredConnectionSocketFactory layeredConnectionSocketFactory) {
        int maxConnTotal;
        ConnectionConfig useConnectionConfig = ObjectUtil.defaultIfNull(connectionConfig, ConnectionConfig.INSTANCE);
        org.apache.http.impl.client.HttpClientBuilder customHttpClientBuilder = HttpClients.custom();
        SSLPacker.pack(customHttpClientBuilder, useConnectionConfig, layeredConnectionSocketFactory);
        int maxConnPerRoute = useConnectionConfig.getMaxConnPerRoute();
        if (maxConnPerRoute > 0) {
            customHttpClientBuilder.setMaxConnPerRoute(maxConnPerRoute);
        }
        if ((maxConnTotal = useConnectionConfig.getMaxConnTotal()) > 0) {
            customHttpClientBuilder.setMaxConnTotal(maxConnTotal);
        }
        customHttpClientBuilder.evictExpiredConnections().evictIdleConnections(30L, TimeUnit.SECONDS);
        RequestConfig requestConfig = RequestConfigBuilder.build(connectionConfig);
        customHttpClientBuilder.setDefaultRequestConfig(requestConfig);
        return customHttpClientBuilder.build();
    }
}

