/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.filetransfer.ftp;

import com.feilong.core.Validate;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.io.entity.FileInfoEntity;
import com.feilong.io.entity.FileType;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.lib.net.ftp.FTPClient;
import com.feilong.lib.net.ftp.FTPFile;
import com.feilong.lib.net.ftp.FTPReply;
import com.feilong.net.filetransfer.AbstractFileTransfer;
import com.feilong.net.filetransfer.FileTransferException;
import com.feilong.net.filetransfer.ftp.FTPFileTransferConfig;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPFileTransfer
extends AbstractFileTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTPFileTransfer.class);
    private FTPFileTransferConfig ftpFileTransferConfig;
    private FTPClient ftpClient;

    @Override
    protected boolean connect() {
        try {
            String hostName = this.ftpFileTransferConfig.getHostName();
            Validate.notBlank(hostName, "hostName can't be blank!", new Object[0]);
            this.ftpClient.connect(hostName, (int)ObjectUtil.defaultIfNull(this.ftpFileTransferConfig.getPort(), 21));
            LOGGER.debug("connect hostName:[{}]", (Object)hostName);
            String userName = this.ftpFileTransferConfig.getUserName();
            String password = this.ftpFileTransferConfig.getPassword();
            boolean loginResult = this.ftpClient.login(userName, password);
            String message = Slf4jUtil.format("login:[{}],params:[{}],port:[{}]~~~", loginResult, JsonUtil.format(this.ftpFileTransferConfig), this.ftpClient.getDefaultPort());
            LOGGER.debug(message);
            if (!loginResult) {
                throw new FileTransferException(message, new Object[0]);
            }
            int replyCode = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(replyCode)) {
                LOGGER.error("FTP \u670d\u52a1\u62d2\u7edd\u8fde\u63a5\uff01ReplyCode is:{},will ftpClient.disconnect()", (Object)replyCode);
                this.ftpClient.disconnect();
                return false;
            }
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            String systemName = this.ftpClient.getSystemType();
            LOGGER.debug("ftpClient systemName:[{}]", (Object)systemName);
            LOGGER.info("connect:[{}]", (Object)true);
            return true;
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("ftpFileTransferConfig:{}", JsonUtil.format(this.ftpFileTransferConfig));
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected void disconnect() {
        if (this.ftpClient != null && this.ftpClient.isConnected()) {
            try {
                LOGGER.info("ftpClient logout:[{}]", (Object)this.ftpClient.logout());
                this.ftpClient.disconnect();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(StringUtils.center("ftpClient disconnect...", 50, "------"));
                }
            }
            catch (IOException e) {
                throw new FileTransferException("disconnect exception", e);
            }
        }
    }

    @Override
    protected void tryCd(String remoteDirectory) throws Exception {
        boolean flag = this.ftpClient.changeWorkingDirectory(remoteDirectory);
        if (!flag) {
            throw new FileTransferException(StringUtils.trim(this.ftpClient.getReplyString().trim()), new Object[0]);
        }
        LOGGER.debug("cd [{}]", (Object)remoteDirectory);
    }

    @Override
    protected boolean mkdir(String remoteDirectory) {
        try {
            boolean flag = this.ftpClient.makeDirectory(remoteDirectory);
            if (flag) {
                LOGGER.info("mkdir [{}] success~~", (Object)remoteDirectory);
            } else {
                LOGGER.error("mkdir [{}] error,ReplyString :[{}]", (Object)remoteDirectory, (Object)this.ftpClient.getReplyString());
            }
            return flag;
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("can't mkdir,remoteDirectory:[{}]", remoteDirectory);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean upload(FileInputStream fileInputStream, String toFileName) {
        try {
            boolean flag = this.ftpClient.storeFile(toFileName, fileInputStream);
            if (flag) {
                LOGGER.debug("put [{}] success~~", (Object)toFileName);
            } else {
                LOGGER.error("store file error,ReplyString :{}", (Object)this.ftpClient.getReplyString());
            }
            return flag;
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("can't upload fileInputStream,toFileName:[{}]", toFileName);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected Map<String, FileInfoEntity> getLsFileMap(String remotePath) {
        try {
            FTPFile[] ftpFiles;
            Map<String, FileInfoEntity> map = MapUtil.newHashMap();
            for (FTPFile ftpFile : ftpFiles = this.ftpClient.listFiles(remotePath)) {
                map.put(ftpFile.getName(), FTPFileTransfer.buildFileInfoEntity(ftpFile));
            }
            return map;
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    private static FileInfoEntity buildFileInfoEntity(FTPFile ftpFile) {
        FileInfoEntity fileInfoEntity = new FileInfoEntity();
        fileInfoEntity.setFileType(ftpFile.isDirectory() ? FileType.DIRECTORY : FileType.FILE);
        fileInfoEntity.setName(ftpFile.getName());
        fileInfoEntity.setSize(ftpFile.getSize());
        fileInfoEntity.setLastModified(ftpFile.getTimestamp().getTimeInMillis());
        return fileInfoEntity;
    }

    @Override
    protected boolean rmdir(String remotePath) {
        try {
            LOGGER.info("ftpClient cwd root .....");
            this.cd("/");
            boolean flag = this.ftpClient.removeDirectory(remotePath);
            if (flag) {
                LOGGER.info("ftpClient removeDirectory,remotePath [{}]:[{}]", (Object)remotePath, (Object)flag);
            } else {
                LOGGER.warn("ftpClient removeDirectory,remotePath [{}]:[{}] ReplyCode:{}", new Object[]{remotePath, flag, this.ftpClient.getReplyCode()});
            }
            return flag;
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean rm(String remotePath) {
        try {
            LOGGER.info("remotePath:[{}] is [not directory],deleteFile.....", (Object)remotePath);
            boolean flag = this.ftpClient.deleteFile(remotePath);
            if (flag) {
                LOGGER.info("ftpClient deleteFile,remotePath[{}] : [{}]", (Object)remotePath, (Object)flag);
            } else {
                LOGGER.warn("ftpClient deleteFile,remotePath[{}] : [{}] , ReplyCode:[{}]", new Object[]{remotePath, flag, this.ftpClient.getReplyCode()});
            }
            return flag;
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("remotePath:[{}]", remotePath);
            throw new FileTransferException(message, e);
        }
    }

    @Override
    protected boolean isDirectory(String remotePath) {
        return this.cd(remotePath);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean downRemoteSingleFile(String remoteSingleFile, String filePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public void setFtpFileTransferConfig(FTPFileTransferConfig ftpFileTransferConfig) {
        this.ftpFileTransferConfig = ftpFileTransferConfig;
    }
}

