/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.net.filetransfer;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.FilenameUtil;
import com.feilong.io.IOUtil;
import com.feilong.io.entity.FileInfoEntity;
import com.feilong.io.entity.FileType;
import com.feilong.json.JsonUtil;
import com.feilong.net.filetransfer.FileTransfer;
import com.feilong.net.filetransfer.FileTransferException;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileTransfer
implements FileTransfer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileTransfer.class);

    @Override
    public void download(String localAbsoluteDirectoryPath, String ... remotePaths) {
        Validate.notEmpty(remotePaths, "remotePaths can't be null/empty!", new Object[0]);
        for (String remotePath : remotePaths) {
            Validate.notBlank(remotePath, "remotePath can't be blank!", new Object[0]);
        }
        Validate.notBlank(localAbsoluteDirectoryPath, "localAbsoluteDirectoryPath can't be blank!", new Object[0]);
        boolean isConnectSuccess = this.connect();
        if (isConnectSuccess) {
            String remotePath;
            String[] stringArray = remotePaths;
            int n = stringArray.length;
            for (int i = 0; i < n && (isConnectSuccess = this.downloadDontClose(remotePath = stringArray[i], localAbsoluteDirectoryPath)); ++i) {
            }
            this.disconnect();
        }
    }

    @Override
    public boolean upload(String remoteDirectory, String ... batchLocalFileFullPaths) {
        Validate.notBlank(remoteDirectory, "remoteDirectory can't be blank!", new Object[0]);
        Validate.notEmpty(batchLocalFileFullPaths, "batchLocalFileFullPaths can't be null/empty!", new Object[0]);
        for (String localFileFullPath : batchLocalFileFullPaths) {
            Validate.notBlank(localFileFullPath, "localFileFullPath can't be blank!", new Object[0]);
            Validate.isTrue(FileUtil.isExistFile(localFileFullPath), "localFileFullPath:" + localFileFullPath + "  not exist", new Object[0]);
        }
        LOGGER.debug("will put:[{}] to:[{}]", (Object)batchLocalFileFullPaths, (Object)remoteDirectory);
        boolean isConnectSuccess = this.connect();
        this.checkOrMkdirs(remoteDirectory);
        if (isConnectSuccess) {
            String singleLocalFileFullPath;
            String[] stringArray = batchLocalFileFullPaths;
            int n = stringArray.length;
            for (int i = 0; i < n && (isConnectSuccess = this.uploadDontClose(singleLocalFileFullPath = stringArray[i], remoteDirectory)); ++i) {
            }
            this.disconnect();
            return isConnectSuccess;
        }
        return false;
    }

    protected void checkOrMkdirs(String remoteDirectory) {
        LOGGER.info("begin checkOrMkdirs remoteDirectory:[{}]", (Object)remoteDirectory);
        try {
            this.tryCd(remoteDirectory);
        }
        catch (Exception e) {
            LOGGER.warn("can't cd:[{}],cause by:[{}],will try [mkdirs]~~", (Object)remoteDirectory, (Object)e.getMessage());
            List<String> list = FilenameUtil.getParentPathList(remoteDirectory);
            Collections.reverse(list);
            list.add(remoteDirectory);
            for (String folder : list) {
                try {
                    this.tryCd(folder);
                }
                catch (Exception e1) {
                    LOGGER.info("can't cd:[{}],cause by:[{}],will try mkdir", (Object)folder, (Object)e1.getMessage());
                    this.mkdir(folder);
                    this.cd(folder);
                }
            }
        }
    }

    protected abstract void tryCd(String var1) throws Exception;

    @Override
    public Map<String, FileInfoEntity> getFileEntityMap(String remotePath, String ... fileNames) {
        Validate.notBlank(remotePath, "remotePath can't be blank!", new Object[0]);
        boolean isConnectSuccess = this.connect();
        if (!isConnectSuccess) {
            return null;
        }
        Map<String, FileInfoEntity> lsFileMap = this.getLsFileMap(remotePath);
        Map<String, FileInfoEntity> fileEntityMap = MapUtil.getSubMap(lsFileMap, fileNames);
        this.disconnect();
        return fileEntityMap;
    }

    @Override
    public boolean delete(String ... remoteAbsolutePaths) {
        Validate.notEmpty(remoteAbsolutePaths, "remoteAbsolutePaths can't be null/empty!", new Object[0]);
        for (String remoteAbsolutePath : remoteAbsolutePaths) {
            Validate.notBlank(remoteAbsolutePath, "remoteAbsolutePath can't be blank!", new Object[0]);
            if (!"/".equals(remoteAbsolutePath)) continue;
            throw new UnsupportedOperationException("un supported delete '/'remotePath ");
        }
        boolean isConnectSuccess = this.connect();
        if (isConnectSuccess) {
            try {
                int n = this.deleteDontClose(remoteAbsolutePaths) ? 1 : 0;
                return n != 0;
            }
            catch (Exception e) {
                throw new FileTransferException("deleteDontClose exception", e);
            }
            finally {
                this.disconnect();
            }
        }
        return false;
    }

    protected abstract boolean connect();

    protected abstract void disconnect();

    protected abstract boolean rm(String var1);

    protected abstract boolean rmdir(String var1);

    protected abstract boolean isDirectory(String var1);

    protected abstract Map<String, FileInfoEntity> getLsFileMap(String var1);

    protected boolean cd(String remoteDirectory) {
        try {
            this.tryCd(remoteDirectory);
            return true;
        }
        catch (Exception e) {
            String message = Slf4jUtil.format("can't cd:[{}]", remoteDirectory);
            throw new FileTransferException(message, e);
        }
    }

    protected abstract boolean mkdir(String var1);

    protected abstract boolean upload(FileInputStream var1, String var2);

    protected abstract boolean downRemoteSingleFile(String var1, String var2);

    private boolean deleteDontClose(String ... remoteAbsolutePaths) {
        boolean isSuccess = false;
        for (String remotePath : remoteAbsolutePaths) {
            boolean isDirectory = this.isDirectory(remotePath);
            if (isDirectory) {
                LOGGER.debug("remotePath :[{}] is [directory],will removeDirectory.....", (Object)remotePath);
                Map<String, FileInfoEntity> map = this.getLsFileMap(remotePath);
                for (Map.Entry<String, FileInfoEntity> entry : map.entrySet()) {
                    String key = entry.getKey();
                    this.deleteDontClose(AbstractFileTransfer.joinPath(remotePath, key));
                }
                LOGGER.info("channelSftp rmdir,remotePath [{}]", (Object)remotePath);
                isSuccess = this.rmdir(remotePath);
                continue;
            }
            LOGGER.trace("remotePath:[{}] is [not directory],will rm....", (Object)remotePath);
            isSuccess = this.rm(remotePath);
            this.logInfoOrError(isSuccess, "remove remotePath:[{}] [{}]", remotePath, this.buildResultString(isSuccess));
        }
        return isSuccess;
    }

    private boolean downloadDontClose(String remotePath, String localAbsoluteDirectoryPath) {
        boolean isSuccess = false;
        File file = new File(remotePath);
        String remoteFileName = file.getName();
        String filePath = localAbsoluteDirectoryPath + "/" + remoteFileName;
        if (this.isDirectory(remotePath)) {
            LOGGER.debug("will create directory:[{}]", (Object)localAbsoluteDirectoryPath);
            FileUtil.createDirectory(localAbsoluteDirectoryPath);
            Map<String, FileInfoEntity> lsFileMap = this.getLsFileMap(remotePath);
            for (Map.Entry<String, FileInfoEntity> entry : lsFileMap.entrySet()) {
                String key = entry.getKey();
                isSuccess = this.downloadDontClose(remotePath + "/" + key, filePath);
            }
        } else {
            Date beginDate = DateUtil.now();
            LOGGER.trace("remotePath:[{}] will be download to [{}]", (Object)remotePath, (Object)filePath);
            FileUtil.createDirectoryByFilePath(filePath);
            isSuccess = this.downRemoteSingleFile(remotePath, filePath);
            this.logAfterDownRemoteSingleFile(remotePath, isSuccess, filePath, beginDate);
        }
        return isSuccess;
    }

    private void logAfterDownRemoteSingleFile(String remotePath, boolean isSuccess, String filePath, Date beginDate) {
        if (LOGGER.isInfoEnabled()) {
            String pattern = "downRemoteSingleFile remotePath:[{}] to [{}] [{}], use time: [{}]";
            this.logInfoOrError(isSuccess, pattern, remotePath, filePath, this.buildResultString(isSuccess), DateUtil.formatDuration(beginDate));
        }
    }

    protected String buildResultString(boolean isSuccess) {
        return isSuccess ? "success" : "fail!!";
    }

    protected void logInfoOrError(boolean isSuccess, String messagePattern, Object ... args) {
        if (LOGGER.isInfoEnabled()) {
            String message = Slf4jUtil.format(messagePattern, args);
            if (isSuccess) {
                LOGGER.info(message);
            } else {
                LOGGER.error(message);
            }
        }
    }

    private boolean uploadDontClose(String localFileFullPath, String remoteDirectory) {
        File localFile = new File(localFileFullPath);
        LOGGER.trace("localFile absolutePath:[{}],remoteDirectory:[{}]", (Object)localFile.getAbsolutePath(), (Object)remoteDirectory);
        boolean isSuccess = this.cd(remoteDirectory);
        if (!isSuccess) {
            LOGGER.error("cd:[{}] error~~~~", (Object)remoteDirectory);
            return false;
        }
        LOGGER.debug("cd:[{}] success~~~~", (Object)remoteDirectory);
        String localFileName = localFile.getName();
        if (localFile.isFile()) {
            isSuccess = this.uploadFile(localFileFullPath, remoteDirectory, localFileName);
        } else if (localFile.isDirectory()) {
            this.uploadDirectory(remoteDirectory, localFile, localFileName);
        }
        return isSuccess;
    }

    private boolean uploadFile(String localFileFullPath, String remoteDirectory, String localFileName) {
        LOGGER.debug("begin put:[{}] to remoteDirectory:[{}]", (Object)localFileName, (Object)remoteDirectory);
        FileInputStream fileInputStream = FileUtil.getFileInputStream(localFileFullPath);
        boolean isSuccess = this.upload(fileInputStream, localFileName);
        this.logInfoOrError(isSuccess, "put [{}] to [{}] [{}]", localFileFullPath, remoteDirectory, this.buildResultString(isSuccess));
        IOUtil.closeQuietly(fileInputStream);
        return isSuccess;
    }

    private void uploadDirectory(String remoteDirectory, File localFile, String localFileName) {
        if (!this.isExistsSameNameAndTypeFile(remoteDirectory, localFile)) {
            String dirNameToCreate = localFileName;
            boolean isSuccess = this.mkdir(dirNameToCreate);
            this.logInfoOrError(isSuccess, "mkdir:[{}] [{}]~~~~", dirNameToCreate, this.buildResultString(isSuccess));
        }
        for (File childrenFile : localFile.listFiles()) {
            this.uploadDontClose(childrenFile.getAbsolutePath(), remoteDirectory + "/" + localFileName);
        }
    }

    private boolean isExistsSameNameAndTypeFile(String remotePath, File file) {
        String fileName;
        FileInfoEntity fileInfoEntity;
        Map<String, FileInfoEntity> lsFileMap = this.getLsFileMap(remotePath);
        if (Validator.isNullOrEmpty(lsFileMap)) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(JsonUtil.format(lsFileMap));
        }
        if (null == (fileInfoEntity = lsFileMap.get(fileName = file.getName()))) {
            return false;
        }
        return AbstractFileTransfer.isExistsSameNameAndTypeFile(file, fileName, fileInfoEntity);
    }

    private static boolean isExistsSameNameAndTypeFile(File file, String fileName, FileInfoEntity fileInfoEntity) {
        boolean sameDirectory;
        boolean isFile = file.isFile();
        String type = isFile ? "isFile" : "isDirectory";
        LOGGER.debug("Input fileName:[{}],type:[{}]", (Object)fileName, (Object)type);
        boolean isDirectoryFileInfoEntity = fileInfoEntity.getFileType() == FileType.DIRECTORY;
        boolean sameFile = isFile && !isDirectoryFileInfoEntity;
        boolean bl = sameDirectory = file.isDirectory() && isDirectoryFileInfoEntity;
        if (sameFile || sameDirectory) {
            LOGGER.debug("hasSameNameAndTypeFile,filename:[{}],type:[{}]", (Object)type, (Object)fileName);
            return true;
        }
        return false;
    }

    private static String joinPath(String directoryPath, String ftpFileName) {
        return directoryPath + (directoryPath.endsWith("/") ? "" : "/") + ftpFileName;
    }
}

