/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArray;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObjectBuilder;
import com.feilong.lib.json.JSONObjectToBeanUtil;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.ProcessValueUtil;
import com.feilong.lib.json.ToStringUtil;
import com.feilong.lib.json.util.CycleDetectionStrategy;
import com.feilong.lib.json.util.JSONUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class JSONObject
implements JSON {
    private static final long serialVersionUID = -7895449812672706822L;
    private boolean nullObject;
    final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public static JSONObject fromObject(Object object) {
        return JSONObject.fromObject(object, new JsonConfig());
    }

    public static JSONObject fromObject(Object object, JsonConfig jsonConfig) {
        return JSONObjectBuilder.build(object, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject) {
        return JSONObjectToBeanUtil.toBean(jsonObject);
    }

    public static Object toBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        return JSONObjectToBeanUtil.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, Object root, JsonConfig jsonConfig) {
        return JSONObject.toBean(jsonObject, root, jsonConfig);
    }

    public JSONObject() {
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject accumulate(String key, Object value, JsonConfig jsonConfig) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        if (!this.properties.containsKey(key)) {
            this.setInternal(key, value, jsonConfig);
        } else {
            Object o = this.get(key);
            if (o instanceof JSONArray) {
                ((JSONArray)o).element(value, jsonConfig);
            } else {
                this.setInternal(key, new JSONArray().element(o).element(value, jsonConfig), jsonConfig);
            }
        }
        return this;
    }

    public JSONObject element(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            value = ProcessValueUtil.processJsonObjectValue(key, value, jsonConfig);
            this._setInternal(key, value);
        } else {
            this.properties.remove(key);
        }
        return this;
    }

    public Object get(String key) {
        this.verifyIsNull();
        return this.properties.get(key);
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator<String> keys() {
        this.verifyIsNull();
        Set<String> keySet = Collections.unmodifiableSet(this.properties.keySet());
        return keySet.iterator();
    }

    public JSONArray names(JsonConfig jsonConfig) {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            ja.element(keys.next(), jsonConfig);
        }
        return ja;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        return ToStringUtil.toString(this.properties);
    }

    @Override
    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        return ToStringUtil.toString(this.properties, indentFactor, indent);
    }

    private JSONObject _setInternal(String key, Object value) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (JSONUtils.isString(value) && JSONUtils.mayBeJSON(String.valueOf(value))) {
            this.properties.put(key, value);
        } else if (CycleDetectionStrategy.IGNORE_PROPERTY_OBJ != value && CycleDetectionStrategy.IGNORE_PROPERTY_ARR != value) {
            this.properties.put(key, value);
        }
        return this;
    }

    JSONObject setInternal(String key, Object value, JsonConfig jsonConfig) {
        Object processJsonObjectValue = ProcessValueUtil.processJsonObjectValue(key, value, jsonConfig);
        return this._setInternal(key, processJsonObjectValue);
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }
}

