/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.json;

import com.feilong.lib.ezmorph.Morpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import com.feilong.lib.json.JSON;
import com.feilong.lib.json.JSONArrayBuilder;
import com.feilong.lib.json.JSONException;
import com.feilong.lib.json.JSONFunction;
import com.feilong.lib.json.JSONNull;
import com.feilong.lib.json.JSONObject;
import com.feilong.lib.json.JsonConfig;
import com.feilong.lib.json.ProcessValueUtil;
import com.feilong.lib.json.ToStringUtil;
import com.feilong.lib.json.util.JSONUtils;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class JSONArray
implements JSON {
    private static final long serialVersionUID = -1663435868052425703L;
    final List elements = new ArrayList();

    public static JSONArray fromObject(Object object) {
        return JSONArray.fromObject(object, new JsonConfig());
    }

    public static JSONArray fromObject(Object object, JsonConfig jsonConfig) {
        return JSONArrayBuilder.fromObject(object, jsonConfig);
    }

    public void add(int index, Object value) {
        this.add(index, value, new JsonConfig());
    }

    private void add(int index, Object value, JsonConfig jsonConfig) {
        this.elements.add(index, ProcessValueUtil.processArrayValue(value, jsonConfig));
    }

    public void clear() {
        this.elements.clear();
    }

    private JSONArray element(int index, Object value, JsonConfig jsonConfig) {
        JSONUtils.testValidity(value);
        if (index < 0) {
            throw new JSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.size()) {
            this.elements.set(index, ProcessValueUtil.processArrayValue(value, jsonConfig));
        } else {
            while (index != this.size()) {
                this.element(JSONNull.getInstance());
            }
            this.element(value, jsonConfig);
        }
        return this;
    }

    private JSONArray element(JSONNull value) {
        this.elements.add(value);
        return this;
    }

    JSONArray element(JSONObject value) {
        this.elements.add(value);
        return this;
    }

    JSONArray element(Object value) {
        return this.element(value, new JsonConfig());
    }

    JSONArray element(Object value, JsonConfig jsonConfig) {
        return this.addValue(value, jsonConfig);
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public JSONObject getJSONObject(int index) {
        Object o = this.get(index);
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator iterator() {
        return new JSONArrayListIterator();
    }

    public Object remove(int index) {
        return this.elements.remove(index);
    }

    public Object set(int index, Object value) {
        JsonConfig jsonConfig = new JsonConfig();
        Object previous = this.get(index);
        this.element(index, value, jsonConfig);
        return previous;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return ToStringUtil.toString(this.elements);
    }

    @Override
    public String toString(int indentFactor, int indent) {
        int len = this.size();
        if (len == 0) {
            return "[]";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        List elements2 = this.elements;
        return ToStringUtil.toString(elements2, indentFactor, indent);
    }

    protected JSONArray addString(String str) {
        if (str != null) {
            this.elements.add(str);
        }
        return this;
    }

    JSONArray addValue(Object value, JsonConfig jsonConfig) {
        this.elements.add(ProcessValueUtil.processArrayValue(value, jsonConfig));
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONArray)) {
            return false;
        }
        JSONArray other = (JSONArray)obj;
        if (other.size() != this.size()) {
            return false;
        }
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            Object o1 = this.get(i);
            Object o2 = other.get(i);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                JSONArray a = (JSONArray)o2;
                JSONArray e = (JSONArray)o1;
                if (a.equals(e)) continue;
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.INSTANCE ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.INSTANCE ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 29;
        for (Object element : this.elements) {
            hashcode += JSONUtils.hashCode(element);
        }
        return hashcode;
    }

    private class JSONArrayListIterator
    implements ListIterator {
        int currentIndex = 0;
        int lastIndex = -1;

        JSONArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != JSONArray.this.size();
        }

        @Override
        public Object next() {
            try {
                Object next = JSONArray.this.get(this.currentIndex);
                this.lastIndex = this.currentIndex++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            try {
                JSONArray.this.remove(this.lastIndex);
                if (this.lastIndex < this.currentIndex) {
                    --this.currentIndex;
                }
                this.lastIndex = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex != 0;
        }

        public Object previous() {
            try {
                int index = this.currentIndex - 1;
                Object previous = JSONArray.this.get(index);
                this.lastIndex = this.currentIndex = index;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.currentIndex;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public void set(Object obj) {
            if (this.lastIndex == -1) {
                throw new IllegalStateException();
            }
            try {
                JSONArray.this.set(this.lastIndex, obj);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object obj) {
            try {
                JSONArray.this.add(this.currentIndex++, obj);
                this.lastIndex = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

