/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.primitive;

import com.feilong.lib.ezmorph.IntegerValueUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class ShortMorpher
extends AbstractPrimitiveMorpher<Short> {
    public ShortMorpher() {
    }

    public ShortMorpher(short defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public short morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return (Short)this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        try {
            return Short.parseShort(IntegerValueUtil.getIntegerValue(value));
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return (Short)this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return Short.TYPE;
    }
}

