/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.primitive;

import com.feilong.lib.ezmorph.IntegerValueUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class ByteMorpher
extends AbstractPrimitiveMorpher<Byte> {
    public ByteMorpher() {
    }

    public ByteMorpher(byte defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public byte morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return (Byte)this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        byte i = 0;
        try {
            i = Byte.parseByte(IntegerValueUtil.getIntegerValue(value));
            return i;
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return (Byte)this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return Byte.TYPE;
    }
}

