/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.core.lang.ObjectUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.object.AbstractObjectMorpher;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class DateMorpher
extends AbstractObjectMorpher<Date> {
    private final String[] formats;
    private final boolean lenient;
    private final Locale locale;

    public DateMorpher(String ... formats) {
        this(formats, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, Locale locale, boolean lenient) {
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = ObjectUtil.defaultIfNull(locale, Locale.getDefault());
        this.lenient = lenient;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(value.getClass() + " is not supported");
        }
        String strValue = (String)value;
        SimpleDateFormat dateParser = null;
        for (int i = 0; i < this.formats.length; ++i) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(this.formats[i], this.locale);
            } else {
                dateParser.applyPattern(this.formats[i]);
            }
            dateParser.setLenient(this.lenient);
            try {
                return dateParser.parse(strValue.toLowerCase());
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Unable to parse the date " + value);
    }

    @Override
    public Class<?> morphsTo() {
        return Date.class;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }
}

