/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.object;

import com.feilong.lib.ezmorph.IntegerValueUtil;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.object.AbstractObjectMorpher;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigIntegerMorpher
extends AbstractObjectMorpher {
    private BigInteger defaultValue;

    public BigIntegerMorpher() {
    }

    public BigIntegerMorpher(BigInteger defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object morph(Object value) {
        if (value instanceof BigInteger) {
            return value;
        }
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Float) {
                Float f = (Float)value;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof Double) {
                Double d = (Double)value;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toBigInteger();
            }
            return BigInteger.valueOf(((Number)value).longValue());
        }
        try {
            String str = IntegerValueUtil.getIntegerValue(value);
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class<?> morphsTo() {
        return BigInteger.class;
    }
}

