/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.bean;

import com.feilong.core.bean.PropertyUtil;
import com.feilong.lib.beanutils.DynaProperty;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.MorpherRegistry;
import com.feilong.lib.ezmorph.ObjectMorpher;
import com.feilong.lib.ezmorph.object.IdentityObjectMorpher;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanMorpher
implements ObjectMorpher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanMorpher.class);
    private final Class<?> beanClass;
    private final boolean lenient;
    private final MorpherRegistry morpherRegistry;

    public BeanMorpher(Class<?> beanClass, MorpherRegistry morpherRegistry) {
        this(beanClass, morpherRegistry, false);
    }

    public BeanMorpher(Class<?> beanClass, MorpherRegistry morpherRegistry, boolean lenient) {
        BeanMorpher.validateClass(beanClass);
        if (morpherRegistry == null) {
            throw new MorphException("morpherRegistry is null");
        }
        this.beanClass = beanClass;
        this.morpherRegistry = morpherRegistry;
        this.lenient = lenient;
    }

    @Override
    public Object morph(Object sourceBean) {
        if (sourceBean == null) {
            return null;
        }
        if (!this.supports(sourceBean.getClass())) {
            throw new MorphException("unsupported class: " + sourceBean.getClass().getName());
        }
        Object targetBean = null;
        try {
            targetBean = this.beanClass.newInstance();
            PropertyDescriptor[] targetPropertyDescriptors = PropertyUtil.getPropertyDescriptors(this.beanClass);
            for (int i = 0; i < targetPropertyDescriptors.length; ++i) {
                PropertyDescriptor targetPropertyDescriptor = targetPropertyDescriptors[i];
                String name = targetPropertyDescriptor.getName();
                if (targetPropertyDescriptor.getWriteMethod() == null) {
                    LOGGER.info("Property '{}.{}' has no write method. SKIPPED.", (Object)this.beanClass.getName(), (Object)name);
                    continue;
                }
                Class<?> sourceType = null;
                if (sourceBean instanceof DynaBean) {
                    DynaBean dynaBean = (DynaBean)sourceBean;
                    DynaProperty dynaProperty = dynaBean.getDynaClass().getDynaProperty(name);
                    if (dynaProperty == null) {
                        LOGGER.warn("DynaProperty '{}' does not exist. SKIPPED.", (Object)name);
                        continue;
                    }
                    sourceType = dynaProperty.getType();
                } else {
                    PropertyDescriptor sourcePropertyDescriptor = PropertyUtils.getPropertyDescriptor(sourceBean, name);
                    if (sourcePropertyDescriptor == null) {
                        LOGGER.warn("Property '{}.{}' does not exist. SKIPPED.", (Object)sourceBean.getClass().getName(), (Object)name);
                        continue;
                    }
                    if (sourcePropertyDescriptor.getReadMethod() == null) {
                        LOGGER.warn("Property '{}.{}' has no read method. SKIPPED.", (Object)sourceBean.getClass().getName(), (Object)name);
                        continue;
                    }
                    sourceType = sourcePropertyDescriptor.getPropertyType();
                }
                Class<?> targetType = targetPropertyDescriptor.getPropertyType();
                Object value = PropertyUtils.getProperty(sourceBean, name);
                this.setProperty(targetBean, name, sourceType, targetType, value);
            }
        }
        catch (MorphException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MorphException(e);
        }
        return targetBean;
    }

    @Override
    public Class<?> morphsTo() {
        return this.beanClass;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return !clazz.isArray();
    }

    private void setProperty(Object targetBean, String name, Class<?> sourceType, Class<?> targetType, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (targetType.isAssignableFrom(sourceType)) {
            if (value == null && targetType.isPrimitive()) {
                value = this.morpherRegistry.morph(targetType, value);
            }
            PropertyUtils.setProperty(targetBean, name, value);
            return;
        }
        if (targetType.equals(Object.class)) {
            PropertyUtils.setProperty(targetBean, name, value);
            return;
        }
        if (value == null) {
            if (targetType.isPrimitive()) {
                PropertyUtils.setProperty(targetBean, name, this.morpherRegistry.morph(targetType, value));
            }
            return;
        }
        if (IdentityObjectMorpher.INSTANCE == this.morpherRegistry.getMorpherFor(targetType)) {
            if (!this.lenient) {
                throw new MorphException("Can't find a morpher for target class " + targetType.getName() + " (" + name + ")");
            }
            LOGGER.info("Can't find a morpher for target class {} ({}) SKIPPED", (Object)targetType.getName(), (Object)name);
        } else {
            PropertyUtils.setProperty(targetBean, name, this.morpherRegistry.morph(targetType, value));
        }
    }

    private static void validateClass(Class<?> clazz) {
        if (clazz == null) {
            throw new MorphException("target class is null");
        }
        if (clazz.isPrimitive()) {
            throw new MorphException("target class is a primitive");
        }
        if (clazz.isArray()) {
            throw new MorphException("target class is an array");
        }
        if (clazz.isInterface()) {
            throw new MorphException("target class is an interface");
        }
        if (DynaBean.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a DynaBean");
        }
        if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a wrapper");
        }
        if (String.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a String");
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Collection");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Map");
        }
    }
}

