/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.lib.ezmorph.array;

import com.feilong.lib.ezmorph.MorphException;
import com.feilong.lib.ezmorph.array.AbstractArrayMorpher;
import com.feilong.lib.ezmorph.primitive.CharMorpher;
import java.lang.reflect.Array;

public final class CharArrayMorpher
extends AbstractArrayMorpher {
    private static final Class<?> CHAR_ARRAY_CLASS = char[].class;
    private char defaultValue;

    public CharArrayMorpher() {
        super(false);
    }

    public CharArrayMorpher(char defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public char getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (CHAR_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return array;
        }
        if (array.getClass().isArray()) {
            CharMorpher morpher;
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = CharArrayMorpher.createDimensions(dims, length);
            Object result = Array.newInstance(Character.TYPE, dimensions);
            CharMorpher charMorpher = morpher = this.isUseDefault() ? new CharMorpher(this.defaultValue) : new CharMorpher();
            if (dims == 1) {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, Character.valueOf(morpher.morph(Array.get(array, index))));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + array.getClass());
    }

    @Override
    public Class<?> morphsTo() {
        return CHAR_ARRAY_CLASS;
    }
}

